/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import java.time.Instant;
import java.util.List;
import software.amazon.codeguruprofilerjavaagent.profile.ClassSummary;
import software.amazon.codeguruprofilerjavaagent.profile.HeapSummary;

public final class HeapSummaries {
    private final HeapSummary latestSummary;

    private HeapSummaries(HeapSummary latestSummary) {
        this.latestSummary = latestSummary;
    }

    HeapSummary getLatestSummary() {
        return this.latestSummary;
    }

    public static class Builder {
        private HeapSummary latestSummary;

        public Builder capture(Instant captureTimestamp, long uptimeMillis, Long maxHeapAvailableBytes, Long heapUsedBytes, List<ClassSummary> classSummaries) {
            if (this.latestSummary == null || captureTimestamp.isAfter(this.latestSummary.getCaptureTimestamp())) {
                this.latestSummary = new HeapSummary(captureTimestamp, uptimeMillis, maxHeapAvailableBytes, heapUsedBytes, classSummaries);
            }
            return this;
        }

        public Builder clear() {
            this.latestSummary = null;
            return this;
        }

        public HeapSummaries build() {
            return new HeapSummaries(this.latestSummary);
        }
    }
}

