/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.beans.ConstructorProperties;
import java.util.logging.Logger;
import lombok.NonNull;
import software.amazon.codeguruprofilerjavaagent.AgentOrchestrator;
import software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClient;
import software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClientProvider;
import software.amazon.codeguruprofilerjavaagent.ProfileReporter;
import software.amazon.codeguruprofilerjavaagent.profile.Profile;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadataProvider;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;

public class ProfilerFinalParameters {
    private static final Logger LOG = Logger.getLogger(ProfilerFinalParameters.class.getName());
    private final String integrationMode;
    private final boolean enableFleetInfoLookup;
    private final ErrorsMetadata errorsMetadata;
    @NonNull
    private final CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder codeGuruClientBuilder;
    private AgentMetadata agentMetadata;
    private AgentOrchestrator agentOrchestrator;
    private ProfileReporter<Profile> reporter;
    private CodeGuruProfilerSDKClient $codeGuruClient = null;

    public AgentMetadata getAgentMetadata() {
        if (this.agentMetadata == null) {
            this.agentMetadata = AgentMetadataProvider.buildAgentMetadata(this.enableFleetInfoLookup, this.errorsMetadata, this.integrationMode);
            LOG.info("Built agent metadata for profiler: " + this.agentMetadata);
        }
        return this.agentMetadata;
    }

    public AgentOrchestrator getAgentOrchestrator() {
        if (this.agentOrchestrator == null) {
            this.agentOrchestrator = this.getDefaultSdkClient();
        }
        return this.agentOrchestrator;
    }

    public ProfileReporter<Profile> getReporter() {
        if (this.reporter == null) {
            this.reporter = this.getDefaultSdkClient();
        }
        return this.reporter;
    }

    private CodeGuruProfilerSDKClient getDefaultSdkClient() {
        if (this.$codeGuruClient == null) {
            this.$codeGuruClient = this.codeGuruClientBuilder.agentMetadata(this.getAgentMetadata()).build().getClient();
        }
        return this.$codeGuruClient;
    }

    static ProfilerFinalParameters preBuilt(ProfileReporter<Profile> reporter, AgentOrchestrator agentOrchestrator, AgentMetadata agentMetadata) {
        return ProfilerFinalParameters.builder().codeGuruClientBuilder(CodeGuruProfilerSDKClientProvider.builder()).agentMetadata(agentMetadata).agentOrchestrator(agentOrchestrator).reporter(reporter).build();
    }

    private static String $default$integrationMode() {
        return "";
    }

    private static boolean $default$enableFleetInfoLookup() {
        return true;
    }

    private static ErrorsMetadata $default$errorsMetadata() {
        return new ErrorsMetadata();
    }

    private static AgentMetadata $default$agentMetadata() {
        return null;
    }

    private static AgentOrchestrator $default$agentOrchestrator() {
        return null;
    }

    private static ProfileReporter<Profile> $default$reporter() {
        return null;
    }

    @ConstructorProperties(value={"integrationMode", "enableFleetInfoLookup", "errorsMetadata", "codeGuruClientBuilder", "agentMetadata", "agentOrchestrator", "reporter"})
    ProfilerFinalParameters(String integrationMode, boolean enableFleetInfoLookup, ErrorsMetadata errorsMetadata, @NonNull CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder codeGuruClientBuilder, AgentMetadata agentMetadata, AgentOrchestrator agentOrchestrator, ProfileReporter<Profile> reporter) {
        if (codeGuruClientBuilder == null) {
            throw new NullPointerException("codeGuruClientBuilder");
        }
        this.integrationMode = integrationMode;
        this.enableFleetInfoLookup = enableFleetInfoLookup;
        this.errorsMetadata = errorsMetadata;
        this.codeGuruClientBuilder = codeGuruClientBuilder;
        this.agentMetadata = agentMetadata;
        this.agentOrchestrator = agentOrchestrator;
        this.reporter = reporter;
    }

    public static ProfilerFinalParametersBuilder builder() {
        return new ProfilerFinalParametersBuilder();
    }

    public ProfilerFinalParametersBuilder toBuilder() {
        return new ProfilerFinalParametersBuilder().integrationMode(this.integrationMode).enableFleetInfoLookup(this.enableFleetInfoLookup).errorsMetadata(this.errorsMetadata).codeGuruClientBuilder(this.codeGuruClientBuilder).agentMetadata(this.agentMetadata).agentOrchestrator(this.agentOrchestrator).reporter(this.reporter);
    }

    public String getIntegrationMode() {
        return this.integrationMode;
    }

    public boolean isEnableFleetInfoLookup() {
        return this.enableFleetInfoLookup;
    }

    public ErrorsMetadata getErrorsMetadata() {
        return this.errorsMetadata;
    }

    @NonNull
    public CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder getCodeGuruClientBuilder() {
        return this.codeGuruClientBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfilerFinalParameters)) {
            return false;
        }
        ProfilerFinalParameters other = (ProfilerFinalParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$integrationMode = this.getIntegrationMode();
        String other$integrationMode = other.getIntegrationMode();
        if (this$integrationMode == null ? other$integrationMode != null : !this$integrationMode.equals(other$integrationMode)) {
            return false;
        }
        if (this.isEnableFleetInfoLookup() != other.isEnableFleetInfoLookup()) {
            return false;
        }
        ErrorsMetadata this$errorsMetadata = this.getErrorsMetadata();
        ErrorsMetadata other$errorsMetadata = other.getErrorsMetadata();
        if (this$errorsMetadata == null ? other$errorsMetadata != null : !this$errorsMetadata.equals(other$errorsMetadata)) {
            return false;
        }
        CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder this$codeGuruClientBuilder = this.getCodeGuruClientBuilder();
        CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder other$codeGuruClientBuilder = other.getCodeGuruClientBuilder();
        if (this$codeGuruClientBuilder == null ? other$codeGuruClientBuilder != null : !this$codeGuruClientBuilder.equals(other$codeGuruClientBuilder)) {
            return false;
        }
        AgentMetadata this$agentMetadata = this.getAgentMetadata();
        AgentMetadata other$agentMetadata = other.getAgentMetadata();
        if (this$agentMetadata == null ? other$agentMetadata != null : !this$agentMetadata.equals(other$agentMetadata)) {
            return false;
        }
        AgentOrchestrator this$agentOrchestrator = this.getAgentOrchestrator();
        AgentOrchestrator other$agentOrchestrator = other.getAgentOrchestrator();
        if (this$agentOrchestrator == null ? other$agentOrchestrator != null : !this$agentOrchestrator.equals(other$agentOrchestrator)) {
            return false;
        }
        ProfileReporter<Profile> this$reporter = this.getReporter();
        ProfileReporter<Profile> other$reporter = other.getReporter();
        return !(this$reporter == null ? other$reporter != null : !this$reporter.equals(other$reporter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProfilerFinalParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $integrationMode = this.getIntegrationMode();
        result = result * 59 + ($integrationMode == null ? 43 : $integrationMode.hashCode());
        result = result * 59 + (this.isEnableFleetInfoLookup() ? 79 : 97);
        ErrorsMetadata $errorsMetadata = this.getErrorsMetadata();
        result = result * 59 + ($errorsMetadata == null ? 43 : $errorsMetadata.hashCode());
        CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder $codeGuruClientBuilder = this.getCodeGuruClientBuilder();
        result = result * 59 + ($codeGuruClientBuilder == null ? 43 : $codeGuruClientBuilder.hashCode());
        AgentMetadata $agentMetadata = this.getAgentMetadata();
        result = result * 59 + ($agentMetadata == null ? 43 : $agentMetadata.hashCode());
        AgentOrchestrator $agentOrchestrator = this.getAgentOrchestrator();
        result = result * 59 + ($agentOrchestrator == null ? 43 : $agentOrchestrator.hashCode());
        ProfileReporter<Profile> $reporter = this.getReporter();
        result = result * 59 + ($reporter == null ? 43 : $reporter.hashCode());
        return result;
    }

    public String toString() {
        return "ProfilerFinalParameters(integrationMode=" + this.getIntegrationMode() + ", enableFleetInfoLookup=" + this.isEnableFleetInfoLookup() + ", errorsMetadata=" + this.getErrorsMetadata() + ", codeGuruClientBuilder=" + this.getCodeGuruClientBuilder() + ", agentMetadata=" + this.getAgentMetadata() + ", agentOrchestrator=" + this.getAgentOrchestrator() + ", reporter=" + this.getReporter() + ")";
    }

    public static class ProfilerFinalParametersBuilder {
        private boolean integrationMode$set;
        private String integrationMode;
        private boolean enableFleetInfoLookup$set;
        private boolean enableFleetInfoLookup;
        private boolean errorsMetadata$set;
        private ErrorsMetadata errorsMetadata;
        private CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder codeGuruClientBuilder;
        private boolean agentMetadata$set;
        private AgentMetadata agentMetadata;
        private boolean agentOrchestrator$set;
        private AgentOrchestrator agentOrchestrator;
        private boolean reporter$set;
        private ProfileReporter<Profile> reporter;

        ProfilerFinalParametersBuilder() {
        }

        public ProfilerFinalParametersBuilder integrationMode(String integrationMode) {
            this.integrationMode = integrationMode;
            this.integrationMode$set = true;
            return this;
        }

        public ProfilerFinalParametersBuilder enableFleetInfoLookup(boolean enableFleetInfoLookup) {
            this.enableFleetInfoLookup = enableFleetInfoLookup;
            this.enableFleetInfoLookup$set = true;
            return this;
        }

        public ProfilerFinalParametersBuilder errorsMetadata(ErrorsMetadata errorsMetadata) {
            this.errorsMetadata = errorsMetadata;
            this.errorsMetadata$set = true;
            return this;
        }

        public ProfilerFinalParametersBuilder codeGuruClientBuilder(CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder codeGuruClientBuilder) {
            this.codeGuruClientBuilder = codeGuruClientBuilder;
            return this;
        }

        public ProfilerFinalParametersBuilder agentMetadata(AgentMetadata agentMetadata) {
            this.agentMetadata = agentMetadata;
            this.agentMetadata$set = true;
            return this;
        }

        public ProfilerFinalParametersBuilder agentOrchestrator(AgentOrchestrator agentOrchestrator) {
            this.agentOrchestrator = agentOrchestrator;
            this.agentOrchestrator$set = true;
            return this;
        }

        public ProfilerFinalParametersBuilder reporter(ProfileReporter<Profile> reporter) {
            this.reporter = reporter;
            this.reporter$set = true;
            return this;
        }

        public ProfilerFinalParameters build() {
            return new ProfilerFinalParameters(this.integrationMode$set ? this.integrationMode : ProfilerFinalParameters.$default$integrationMode(), this.enableFleetInfoLookup$set ? this.enableFleetInfoLookup : ProfilerFinalParameters.$default$enableFleetInfoLookup(), this.errorsMetadata$set ? this.errorsMetadata : ProfilerFinalParameters.$default$errorsMetadata(), this.codeGuruClientBuilder, this.agentMetadata$set ? this.agentMetadata : ProfilerFinalParameters.$default$agentMetadata(), this.agentOrchestrator$set ? this.agentOrchestrator : ProfilerFinalParameters.$default$agentOrchestrator(), this.reporter$set ? this.reporter : ProfilerFinalParameters.$default$reporter());
        }

        public String toString() {
            return "ProfilerFinalParameters.ProfilerFinalParametersBuilder(integrationMode=" + this.integrationMode + ", enableFleetInfoLookup=" + this.enableFleetInfoLookup + ", errorsMetadata=" + this.errorsMetadata + ", codeGuruClientBuilder=" + this.codeGuruClientBuilder + ", agentMetadata=" + this.agentMetadata + ", agentOrchestrator=" + this.agentOrchestrator + ", reporter=" + this.reporter + ")";
        }
    }
}

