/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.jvmagent;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.codeguruprofilerjavaagent.Profiler;
import software.amazon.codeguruprofilerjavaagent.jvmagent.ProfilingArguments;

public class JvmArgumentParser {
    private static final Logger LOG = Logger.getLogger(JvmArgumentParser.class.getName());
    private final String commandLineArguments;
    private final Function<String, String> environment;

    JvmArgumentParser(String commandLineArguments, Function<String, String> environment) {
        this.commandLineArguments = commandLineArguments;
        this.environment = environment;
    }

    public JvmArgumentParser(String commandLineArguments) {
        this(commandLineArguments, System::getenv);
    }

    void configureProfilerBuilder(Profiler.Builder builder) {
        Map<String, String> arguments = this.parseArguments(this.commandLineArguments);
        LOG.log(Level.INFO, "Configuring CodeGuru Profiler using the following arguments: " + arguments.toString());
        builder.integrationModeStandalone();
        this.getProfilingGroupName(arguments).ifPresent(builder::profilingGroupName);
        this.getRegion(arguments).ifPresent(builder::awsRegionToReportTo);
        this.getCredentialProvider(arguments).ifPresent(builder::awsCredentialsProvider);
        this.getHeapSummaryEnabled(arguments).ifPresent(builder::withHeapSummary);
    }

    Optional<String> getProfilingGroupName(Map<String, String> arguments) {
        Optional<String> value = ProfilingArguments.PROFILING_GROUP_NAME.readArgument(arguments, this.environment);
        if (value.isPresent()) {
            return value;
        }
        throw new RuntimeException("Could not find a profiling group name to start the CodeGuru Profiler agent. Add command line argument \"" + ProfilingArguments.PROFILING_GROUP_NAME.commandLineKey + ":yourGroupName,\" or environment variable " + ProfilingArguments.PROFILING_GROUP_NAME.environmentVariableName + " to set it.");
    }

    Optional<Boolean> getHeapSummaryEnabled(Map<String, String> arguments) {
        return ProfilingArguments.HEAP_SUMMARY_ENABLED.readArgument(arguments, this.environment).map(Boolean::parseBoolean);
    }

    Optional<Region> getRegion(Map<String, String> arguments) {
        return ProfilingArguments.REGION.readArgument(arguments, this.environment).map(Region::of);
    }

    private Optional<ProfileCredentialsProvider> getCredentialProvider(Map<String, String> arguments) {
        return ProfilingArguments.CREDENTIAL_PATH.readArgument(arguments, this.environment).map(path -> {
            ProfileFile credFile = ProfileFile.builder().content(Paths.get(path, new String[0])).type(ProfileFile.Type.CREDENTIALS).build();
            return ProfileCredentialsProvider.builder().profileFile(credFile).build();
        });
    }

    Map<String, String> parseArguments(String agentArgs) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        if (agentArgs == null || agentArgs.isEmpty()) {
            return arguments;
        }
        for (String pair : agentArgs.trim().replaceFirst("^,", "").split(",")) {
            String[] argument = pair.trim().split(":");
            if (argument.length <= 1 || argument[0].isEmpty() || argument[1].isEmpty()) {
                throw new RuntimeException("Arguments for CodeGuru Profiler agent should have following format: profilingGroupName:theName,region:us-east-1,credentialPath:path/to/credFile,heapSummaryEnabled:true. Received: " + agentArgs);
            }
            arguments.put(argument[0], argument[1]);
        }
        this.validateArguments(arguments);
        return arguments;
    }

    void validateArguments(Map<String, String> arguments) {
        HashSet validKeys = new HashSet(Arrays.stream(ProfilingArguments.values()).map(a -> a.commandLineKey).collect(Collectors.toList()));
        arguments.forEach((key, value) -> {
            if (!validKeys.contains(key)) {
                throw new RuntimeException("Unknown command line argument for CodeGuru Profiler agent: " + key + ". Possible values are: " + validKeys.toString());
            }
            LOG.log(Level.INFO, "CodeGuru Profiler agent argument: " + key + "=" + value);
        });
    }
}

