/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.jvmagent;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.codeguruprofilerjavaagent.EnvironmentReader;
import software.amazon.codeguruprofilerjavaagent.LambdaProfilerUtils;
import software.amazon.codeguruprofilerjavaagent.ProfilerWithPause;
import software.amazon.codeguruprofilerjavaagent.jvmagent.LambdaJvmArgumentParser;

class ProfilerLambdaExtensionAgent {
    private static final Logger LOG = Logger.getLogger(ProfilerLambdaExtensionAgent.class.getName());
    private static HttpClient client = HttpClientBuilder.create().build();
    private static final String LAMBDA_RUNTIME_API_ENV_VARIABLE = "AWS_LAMBDA_RUNTIME_API";
    private static final String INVOKE_EVENT = "INVOKE";
    private static final String EVENT_TYPE_RESPONSE_JSON_FIELD = "eventType";
    private static final String INVOKED_FUNCTION_ARN_RESPONSE_JSON_FIELD = "invokedFunctionArn";
    private static final String EXTENSION_EVENTS_REGISTERED = String.format("{\"events\": [\"%s\"]}", "INVOKE");
    private static boolean createProfilerAttempted = false;
    protected static final String LAMBDA_EXTENSION_NAME = "jvmagent";
    protected static final String EXTENSION_IDENTIFIER_HEADER = "Lambda-Extension-Identifier";
    protected static final String EXTENSION_NAME_HEADER = "Lambda-Extension-Name";
    protected static final String REGISTER_ACTION = "/register";
    protected static final String NEXT_ACTION = "/event/next";
    private static String BASE_URL;
    private final EnvironmentReader environmentReader;
    protected ProfilerWithPause profilerWithPause;

    ProfilerLambdaExtensionAgent(EnvironmentReader environmentReader) {
        this.environmentReader = environmentReader;
        BASE_URL = String.format("http://%s/2020-01-01/extension", environmentReader.get(LAMBDA_RUNTIME_API_ENV_VARIABLE));
    }

    Thread registerExtensionAndGetProcessNextEventThread(String agentArgs) throws IOException {
        String extensionId = this.registerExtension();
        Thread processNextEventThread = new Thread(() -> {
            HttpGet httpGet = new HttpGet(BASE_URL + NEXT_ACTION);
            httpGet.setHeader(EXTENSION_IDENTIFIER_HEADER, extensionId);
            while (true) {
                this.processNextEvent(httpGet, agentArgs);
            }
        });
        processNextEventThread.setDaemon(true);
        return processNextEventThread;
    }

    String registerExtension() throws IOException {
        HttpPost httpPost = new HttpPost(BASE_URL + REGISTER_ACTION);
        httpPost.setHeader(EXTENSION_NAME_HEADER, LAMBDA_EXTENSION_NAME);
        httpPost.setEntity((HttpEntity)new StringEntity(EXTENSION_EVENTS_REGISTERED));
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(String.format("/register failed for agent : %s with status code : %d and reason : %s", LAMBDA_EXTENSION_NAME, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        String extensionId = response.getFirstHeader(EXTENSION_IDENTIFIER_HEADER).getValue();
        if (extensionId.isEmpty()) {
            throw new RuntimeException(String.format("no extensionId was provided for agent : %s, cannot proceed", LAMBDA_EXTENSION_NAME));
        }
        return extensionId;
    }

    void processNextEvent(HttpGet httpGet, String agentArgs) {
        block7: {
            try {
                HttpResponse response = client.execute((HttpUriRequest)httpGet);
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new RuntimeException(String.format("/event/next failed for agent : %s with status code : %d and reason : %s", LAMBDA_EXTENSION_NAME, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                }
                JSONObject responseJSON = new JSONObject(IoUtils.toUtf8String((InputStream)response.getEntity().getContent()));
                String eventType = responseJSON.getString(EVENT_TYPE_RESPONSE_JSON_FIELD);
                if (!INVOKE_EVENT.equals(eventType)) break block7;
                try {
                    if (!createProfilerAttempted) {
                        String invokedFunctionArn = responseJSON.getString(INVOKED_FUNCTION_ARN_RESPONSE_JSON_FIELD);
                        createProfilerAttempted = true;
                        this.profilerWithPause = this.getLambdaProfiler(agentArgs, invokedFunctionArn);
                    }
                    if (this.profilerWithPause != null) {
                        this.profilerWithPause.pause();
                        this.profilerWithPause.resume(null);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "There was a problem while starting/resuming profiler, disabling profiler. ", e);
                    this.disableProfiler();
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "There was a problem while processing next INVOKE event. ", e);
            }
        }
    }

    private ProfilerWithPause getLambdaProfiler(String agentArgs, String invokedFunctionArn) {
        if (LambdaProfilerUtils.isProfilerEnabled()) {
            this.profilerWithPause = this.attemptToCreateProfiler(agentArgs, invokedFunctionArn);
        }
        return this.profilerWithPause;
    }

    private ProfilerWithPause attemptToCreateProfiler(String agentArgs, String invokedFunctionArn) {
        LambdaJvmArgumentParser argumentParser = new LambdaJvmArgumentParser(agentArgs);
        ProfilerWithPause.Builder builder = ProfilerWithPause.builder();
        builder.environmentReader(this.environmentReader);
        builder.lambdaInvokedFunctionArn(invokedFunctionArn);
        argumentParser.configureProfilerBuilder(builder);
        return builder.build();
    }

    void disableProfiler() {
        if (this.profilerWithPause != null) {
            this.profilerWithPause.stop();
            this.profilerWithPause = null;
        }
    }

    void setHttpClient(HttpClient client) {
        ProfilerLambdaExtensionAgent.client = client;
    }
}

