/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Random;
import software.amazon.codeguruprofilerjavaagent.ThreadDump;
import software.amazon.codeguruprofilerjavaagent.ThreadDumpCollection;
import software.amazon.codeguruprofilerjavaagent.ThreadSupport;

class BasicThreadSupport
implements ThreadSupport {
    static final int MAX_THREADS = 100;
    private final Random random = new Random();
    private final ThreadMXBean threadMBean = ManagementFactory.getThreadMXBean();

    BasicThreadSupport() {
    }

    @Override
    public ThreadDumpCollection dumpAllStackTraces() {
        return this.dumpAllStackTraces(Integer.MAX_VALUE);
    }

    @Override
    public ThreadDumpCollection dumpAllStackTraces(int maxStackDepth) {
        long[] threadIds = this.threadMBean.getAllThreadIds();
        int numThreads = threadIds.length;
        if (numThreads > 100) {
            threadIds = this.getRandomSubArray(threadIds, 100);
        }
        int numThreadsSampled = threadIds.length;
        ThreadInfo[] threadInfos = this.threadMBean.getThreadInfo(threadIds, maxStackDepth);
        ArrayList<ThreadDump> threadDumps = new ArrayList<ThreadDump>(threadInfos.length);
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo == null) continue;
            threadDumps.add(new ThreadDump(threadInfo.getThreadName(), threadInfo.getThreadId(), threadInfo.getThreadState(), threadInfo.isInNative(), threadInfo.getStackTrace()));
        }
        return new ThreadDumpCollection(threadDumps, numThreads, numThreadsSampled);
    }

    long[] getRandomSubArray(long[] threadIds, int subArrayLength) {
        if (threadIds == null || subArrayLength < 0 || subArrayLength >= threadIds.length) {
            return threadIds;
        }
        long[] newThreadIds = new long[subArrayLength];
        int from = this.random.nextInt(threadIds.length);
        int to = from + subArrayLength;
        if (to > threadIds.length) {
            System.arraycopy(threadIds, from, newThreadIds, 0, threadIds.length - from);
            System.arraycopy(threadIds, 0, newThreadIds, threadIds.length - from, to - threadIds.length);
        } else {
            System.arraycopy(threadIds, from, newThreadIds, 0, subArrayLength);
        }
        return newThreadIds;
    }
}

