/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import com.amazonaws.services.lambda.runtime.Context;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.awssdk.services.codeguruprofiler.model.AgentConfiguration;
import software.amazon.awssdk.services.codeguruprofiler.model.MetadataField;
import software.amazon.codeguruprofilerjavaagent.ProfilerFinalParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilerParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommand;
import software.amazon.codeguruprofilerjavaagent.configuration.ProfilerParametersMerger;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInstanceType;

class ProfilingCommandWithPause
extends ProfilingCommand {
    private static final Logger LOG = Logger.getLogger(ProfilingCommandWithPause.class.getName());
    private final ProfilerParametersMerger parametersMerger;
    private Instant lastResumeTime;
    private Instant lastPauseTime;
    private Instant newReportStartTime = null;
    private Duration timeBeforeNextSample;
    private boolean isPaused;
    private Context context;
    private String agentId;
    private boolean isLambdaColdStartRequest;
    private boolean isStandAloneMode;
    private Duration pausedTime;

    ProfilingCommandWithPause(ProfilerParametersMerger parametersMerger, ProfilerParameters parameters, ProfilerFinalParameters profilerFinalParameters) {
        super(parametersMerger, parameters, profilerFinalParameters);
        this.parametersMerger = parametersMerger;
        this.lastResumeTime = Instant.now();
        this.timeBeforeNextSample = parameters.getSamplingInterval();
        this.agentId = UUID.randomUUID().toString();
        this.isLambdaColdStartRequest = true;
        this.isStandAloneMode = "-standalone".equals(this.getParameters().getIntegrationMode());
    }

    @Override
    protected void OnNewProfileStart(Instant now) {
        this.pausedTime = Duration.ZERO;
        this.newReportStartTime = now;
    }

    @Override
    protected Optional<AgentConfiguration> callConfigureAgent() {
        if (!this.isLambdaColdStartRequest) {
            Map<String, String> configureAgentMetadata = this.getConfigureAgentMetadata();
            LOG.info(String.format("Agent metadata for configure agent call : %s", configureAgentMetadata.toString()));
            Optional<AgentConfiguration> newAgentConfig = this.profilerFinalParameters.getAgentOrchestrator().configureAgent(configureAgentMetadata);
            if (newAgentConfig.isPresent()) {
                return newAgentConfig;
            }
            this.notifyFailedAgentConfig();
        }
        LOG.info("This is a Lambda cold start request, using default agent configuration.");
        return Optional.empty();
    }

    @Override
    protected ProfilerParameters buildProfilerParameters(AgentConfiguration agentConfiguration) {
        return this.parametersMerger.buildLambdaProfilerParameters(agentConfiguration, this.context);
    }

    void pauseProfiling() {
        if (this.isProfiling()) {
            this.isPaused = true;
            this.computeTimeBeforeNextSample();
            this.cancelTaskInExecutor();
            this.memoryProfiler.notImplementedPause();
            this.lastPauseTime = this.isStandAloneMode ? null : Instant.now();
        }
    }

    void resumeProfiling(Context context) {
        this.context = context;
        this.isLambdaColdStartRequest = false;
        if (this.isProfiling()) {
            if (this.isPaused) {
                this.scheduleTaskInExecutor(this.timeBeforeNextSample, this.getParameters().getSamplingInterval());
                this.memoryProfiler.notImplementedResume();
                this.lastResumeTime = Instant.now();
                if (!this.isStandAloneMode) {
                    this.pausedTime = this.pausedTime.plus(Duration.between(this.lastPauseTime, this.lastResumeTime));
                }
                this.isPaused = false;
            }
        } else {
            this.scheduleProfiling();
        }
    }

    boolean isSamplingPaused() {
        return this.isPaused;
    }

    @Override
    protected Duration getActiveDurationSinceLastReport(Instant now) {
        if (this.newReportStartTime == null) {
            return Duration.ZERO;
        }
        if (!this.isStandAloneMode) {
            if (this.isPaused && this.lastPauseTime != null) {
                this.pausedTime = this.pausedTime.plus(Duration.between(this.lastPauseTime, now));
            }
            return Duration.between(this.newReportStartTime, now).minus(this.pausedTime);
        }
        return this.getParameters().getSamplingInterval().multipliedBy(this.getNumberOfTimesSampled());
    }

    private void computeTimeBeforeNextSample() {
        Duration samplingInterval = this.getParameters().getSamplingInterval();
        if (!this.isStandAloneMode) {
            Instant now = Instant.now();
            Instant lastSampleTime = this.getLastSampleTime();
            this.timeBeforeNextSample = lastSampleTime == null || lastSampleTime.isBefore(this.lastResumeTime) ? this.timeBeforeNextSample.minus(Duration.between(this.lastResumeTime, now)) : samplingInterval.minus(Duration.between(lastSampleTime, now));
        } else {
            long randomSamplingInterval = ThreadLocalRandom.current().nextLong(1L, samplingInterval.toMillis() + 1L);
            this.timeBeforeNextSample = Duration.ofMillis(randomSamplingInterval);
        }
    }

    private Map<String, String> getConfigureAgentMetadata() {
        HashMap<String, String> configureAgentMetadata = new HashMap<String, String>();
        try {
            configureAgentMetadata.put(MetadataField.AGENT_ID.toString(), this.agentId);
            configureAgentMetadata.put(MetadataField.COMPUTE_PLATFORM.toString(), FleetInstanceType.AWSLambda.name());
            this.getRuntimeVersion().ifPresent(runtimeVersion -> configureAgentMetadata.put(MetadataField.EXECUTION_ENVIRONMENT.toString(), (String)runtimeVersion));
            this.getPreviousExecutionTimeInMilliseconds().ifPresent(previousExecutionTime -> configureAgentMetadata.put(MetadataField.LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS.toString(), String.valueOf(previousExecutionTime)));
            if (this.context != null) {
                configureAgentMetadata.put(MetadataField.LAMBDA_FUNCTION_ARN.toString(), this.context.getInvokedFunctionArn());
                configureAgentMetadata.put(MetadataField.LAMBDA_MEMORY_LIMIT_IN_MB.toString(), String.valueOf(this.context.getMemoryLimitInMB()));
                configureAgentMetadata.put(MetadataField.AWS_REQUEST_ID.toString(), this.context.getAwsRequestId());
                configureAgentMetadata.put(MetadataField.LAMBDA_REMAINING_TIME_IN_MILLISECONDS.toString(), String.valueOf(this.context.getRemainingTimeInMillis()));
            }
        }
        catch (Exception e) {
            this.getErrorsMetadata().recordProfiling(LOG, Level.INFO, "Exception thrown while generating configure agent metadata" + e, e);
        }
        return configureAgentMetadata;
    }

    private Optional<String> getRuntimeVersion() {
        return this.profilerFinalParameters.getAgentMetadata().getRuntimeVersion() != null ? Optional.of(this.profilerFinalParameters.getAgentMetadata().getRuntimeVersion()) : Optional.empty();
    }

    private Optional<Long> getPreviousExecutionTimeInMilliseconds() {
        return this.lastPauseTime != null && this.lastResumeTime != null ? Optional.of(Duration.between(this.lastResumeTime, this.lastPauseTime).abs().toMillis()) : Optional.empty();
    }

    @Override
    protected boolean isFleetTypeIncorrect() {
        FleetInstanceType fleetType = this.profilerFinalParameters.getAgentMetadata().getFleetInfo().map(FleetInfo::getFleetInstanceType).orElse(FleetInstanceType.Unknown);
        if (!FleetInstanceType.AWSLambda.equals((Object)fleetType)) {
            LOG.info("CodeGuru Profiler agent was found to be running on a compute platform other than AWS Lambda. Profiling will be terminated. Please refer to CodeGuru Profiler's documentation to learn more about how to profile AWS Lambda functions");
            return true;
        }
        return false;
    }
}

