/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile;

import java.time.Instant;
import software.amazon.codeguruprofilerjavaagent.profile.AgentDebugInfo;
import software.amazon.codeguruprofilerjavaagent.profile.CallGraph;
import software.amazon.codeguruprofilerjavaagent.profile.FrameEncodings;
import software.amazon.codeguruprofilerjavaagent.profile.HeapSummary;
import software.amazon.codeguruprofilerjavaagent.profile.ProfileBuilder;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.AgentMetadata;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.SamplingMetadata;

public class Profile {
    private final Instant start;
    private final Instant end;
    private final AgentMetadata agentMetadata;
    private final SamplingMetadata samplingMetadata;
    private final FrameEncodings frameEncodings;
    private final CallGraph root;
    private final HeapSummary heapSummary;
    private final AgentDebugInfo agentDebugInfo;

    public Profile(Instant start, Instant end, AgentMetadata agentMetadata, SamplingMetadata samplingMetadata, ProfileBuilder profileBuilder, AgentDebugInfo agentDebugInfo) {
        this.start = start;
        this.end = end;
        this.agentMetadata = agentMetadata;
        this.samplingMetadata = samplingMetadata;
        this.frameEncodings = profileBuilder.getCallGraphBuilder().getFrameEncodings();
        this.root = profileBuilder.getCallGraphBuilder().getCallGraph();
        this.heapSummary = profileBuilder.getHeapSummaryBuilder().build();
        this.agentDebugInfo = agentDebugInfo;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public AgentMetadata getAgentMetadata() {
        return this.agentMetadata;
    }

    public SamplingMetadata getSamplingMetadata() {
        return this.samplingMetadata;
    }

    public FrameEncodings getFrameEncodings() {
        return this.frameEncodings;
    }

    public CallGraph getRoot() {
        return this.root;
    }

    public HeapSummary getHeapSummary() {
        return this.heapSummary;
    }

    public AgentDebugInfo getAgentDebugInfo() {
        return this.agentDebugInfo;
    }
}

