/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.util.function.BiFunction;
import java.util.logging.Logger;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.codeguruprofilerjavaagent.CodeGuruProfilerSDKClientProvider;
import software.amazon.codeguruprofilerjavaagent.IProfiler;
import software.amazon.codeguruprofilerjavaagent.ProfilerFinalParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilerParameters;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommand;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommandAccessor;
import software.amazon.codeguruprofilerjavaagent.ProfilingCommands;
import software.amazon.codeguruprofilerjavaagent.configuration.ProfilerParametersMerger;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.ErrorsMetadata;

public class Profiler
extends ProfilingCommandAccessor
implements IProfiler {
    private static final Logger LOG = Logger.getLogger(Profiler.class.getName());
    private static Profiler singletonActiveProfiler;
    private final ProfilerParametersMerger parametersMerger;
    private final ProfilerParameters parameters;
    private final ProfilerFinalParameters profilerFinalParameters;

    Profiler(ProfilerParameters parameters, ProfilerFinalParameters profilerFinalParameters) {
        this.parametersMerger = new ProfilerParametersMerger(parameters, profilerFinalParameters.getErrorsMetadata());
        this.parameters = parameters;
        this.profilerFinalParameters = profilerFinalParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void start() {
        this.startWithProfilingCommand((parametersMerger, parameters, finalParameters) -> this.createNewProfilingCommand((ProfilerParametersMerger)parametersMerger, (ProfilerParameters)parameters, (ProfilerFinalParameters)finalParameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Class<Profiler> clazz = Profiler.class;
        synchronized (Profiler.class) {
            if (singletonActiveProfiler == this) {
                this.getProfilingCommand().ifPresent(command -> {
                    LOG.info("Stopping the profiler!");
                    command.stopProfiling();
                    this.setProfilingCommand((ProfilingCommands)command, null);
                });
                singletonActiveProfiler = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isRunning() {
        return this.getProfilingCommand().map(ProfilingCommands::isProfilingScheduled).orElse(false);
    }

    @Override
    public boolean isProfiling() {
        return this.getProfilingCommand().map(ProfilingCommands::isProfiling).orElse(false);
    }

    @Override
    ProfilingCommand createNewProfilingCommand(ProfilerParametersMerger parametersMerger, ProfilerParameters params, ProfilerFinalParameters finalParams) {
        return new ProfilingCommand(parametersMerger, params, finalParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startWithProfilingCommand(ProfilingCommandAccessor.TriFunction<ProfilerParametersMerger, ProfilerParameters, ProfilerFinalParameters, ProfilingCommands> profilingCommandProvider) {
        if (this.parameters.getProfilingGroupName() == null) {
            LOG.info("Not starting the profiler as the profiling group name could not be determined automatically and no override was provided");
            return;
        }
        Class<Profiler> clazz = Profiler.class;
        synchronized (Profiler.class) {
            if (singletonActiveProfiler == null) {
                singletonActiveProfiler = this;
            }
            if (singletonActiveProfiler != this) {
                LOG.info("Starting multiple instances of profiler agents is not allowed. Please validate the configuration of the profiler. If this is intentional, then stop the active profiler agent before starting a new one.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            ProfilingCommands profilingCommand = profilingCommandProvider.apply(this.parametersMerger, this.parameters, this.profilerFinalParameters);
            if (this.setProfilingCommand(null, profilingCommand)) {
                LOG.info("Starting the profiler : " + this.parameters);
                profilingCommand.scheduleProfiling();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    ProfilerParameters getParameters() {
        return this.parameters;
    }

    ProfilerFinalParameters getFinalParameters() {
        return this.profilerFinalParameters;
    }

    public String toString() {
        return "Profiler{profilingGroupName=" + this.parameters.getProfilingGroupName() + ", isRunning=" + this.isRunning() + ", isProfiling=" + this.isProfiling() + '}';
    }

    public static class Builder {
        private final ProfilerParameters.ProfilerParametersBuilder parametersBuilder = ProfilerParameters.builder();
        private final ProfilerFinalParameters.ProfilerFinalParametersBuilder finalParametersBuilder = ProfilerFinalParameters.builder();
        private final CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder codeGuruClientBuilder;
        private final BiFunction<ProfilerParameters, ProfilerFinalParameters, Profiler> constructor;
        private final ErrorsMetadata errorsMetadata = new ErrorsMetadata();

        public Builder() {
            this(CodeGuruProfilerSDKClientProvider.builder(), Profiler::new);
            this.codeGuruClientBuilder.errorsMetadata(this.errorsMetadata);
            this.finalParametersBuilder.errorsMetadata(this.errorsMetadata).codeGuruClientBuilder(this.codeGuruClientBuilder);
        }

        public Builder awsCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
            this.codeGuruClientBuilder.awsCredentialsProvider(awsCredentialsProvider);
            return this;
        }

        public Builder awsRegionToReportTo(Region awsRegion) {
            this.codeGuruClientBuilder.awsRegion(awsRegion);
            return this;
        }

        public Builder enableFleetInfoLookup(boolean enableFleetInfoLookup) {
            this.finalParametersBuilder.enableFleetInfoLookup(enableFleetInfoLookup);
            return this;
        }

        public Builder profilingGroupName(String profilingGroupName) {
            this.parametersBuilder.profilingGroupName(profilingGroupName);
            this.codeGuruClientBuilder.profilingGroupName(profilingGroupName);
            return this;
        }

        public Builder integrationModeStandalone() {
            this.parametersBuilder.integrationMode("-standalone");
            return this;
        }

        public Builder withHeapSummary(boolean shouldEnableHeapSummary) {
            this.parametersBuilder.heapSummaryEnabled(shouldEnableHeapSummary);
            return this;
        }

        Builder withAllocationProfiling(boolean shouldEnableAllocationProfiling) {
            this.parametersBuilder.allocationProfilingEnabled(shouldEnableAllocationProfiling);
            return this;
        }

        public Profiler build() {
            return this.constructor.apply(this.parametersBuilder.build(), this.finalParametersBuilder.build());
        }

        public String getProfilingGroupName() {
            return this.parametersBuilder.getProfilingGroupName();
        }

        public AwsCredentialsProvider getAwsCredentialProvider() {
            return this.codeGuruClientBuilder.getAwsCredentialsProvider();
        }

        public Region getAwsRegion() {
            return this.codeGuruClientBuilder.getAwsRegion();
        }

        Builder(CodeGuruProfilerSDKClientProvider.CodeGuruProfilerSDKClientProviderBuilder codeGuruClientBuilder, BiFunction<ProfilerParameters, ProfilerFinalParameters, Profiler> constructor) {
            this.codeGuruClientBuilder = codeGuruClientBuilder;
            this.constructor = constructor;
        }
    }
}

