/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import software.amazon.codeguruprofilerjavaagent.BasicThreadSupport;
import software.amazon.codeguruprofilerjavaagent.ThreadSupport;

public final class ProfilerParameters {
    @NonNull
    private final String profilingGroupName;
    @NonNull
    private final ThreadSupport threadSupport;
    @NonNull
    private final Set<String> excludedThreads;
    private final boolean shouldProfile;
    private final String integrationMode;
    private final long memoryUsageLimit;
    private final boolean heapSummaryEnabled;
    private final boolean allocationProfilingEnabled;
    private final int stackDepthLimit;
    @NonNull
    private final Duration samplingInterval;
    @NonNull
    private final Duration reportingInterval;
    private final boolean addProfilerOverheadAsSamples;
    @NonNull
    private final Duration minimumTimeForReporting;
    private final int dontReportIfSampledLessThanTimes;

    public String toString() {
        return "ProfilerParameters{profilingGroupName='" + this.profilingGroupName + '\'' + ", threadSupport=" + this.threadSupport + ", excludedThreads=" + this.excludedThreads + ", shouldProfile=" + this.shouldProfile + ", integrationMode='" + this.integrationMode + '\'' + ", memoryUsageLimit=" + this.memoryUsageLimit + ", heapSummaryEnabled=" + this.heapSummaryEnabled + ", stackDepthLimit=" + this.stackDepthLimit + ", samplingInterval=" + this.samplingInterval + ", reportingInterval=" + this.reportingInterval + ", addProfilerOverheadAsSamples=" + this.addProfilerOverheadAsSamples + ", minimumTimeForReporting=" + this.minimumTimeForReporting + ", dontReportIfSampledLessThanTimes=" + this.dontReportIfSampledLessThanTimes + '}';
    }

    private static ThreadSupport $default$threadSupport() {
        return new BasicThreadSupport();
    }

    private static Set<String> $default$excludedThreads() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Attach Listener", "Signal Dispatcher")));
    }

    private static boolean $default$shouldProfile() {
        return true;
    }

    private static String $default$integrationMode() {
        return "";
    }

    private static long $default$memoryUsageLimit() {
        return 0x6400000L;
    }

    private static boolean $default$heapSummaryEnabled() {
        return false;
    }

    private static boolean $default$allocationProfilingEnabled() {
        return false;
    }

    private static int $default$stackDepthLimit() {
        return 1000;
    }

    private static Duration $default$samplingInterval() {
        return Duration.ofSeconds(1L);
    }

    private static Duration $default$reportingInterval() {
        return Duration.ofMinutes(5L);
    }

    private static boolean $default$addProfilerOverheadAsSamples() {
        return true;
    }

    private static Duration $default$minimumTimeForReporting() {
        return Duration.ofMinutes(1L);
    }

    private static int $default$dontReportIfSampledLessThanTimes() {
        return 1;
    }

    ProfilerParameters(@NonNull String profilingGroupName, @NonNull ThreadSupport threadSupport, @NonNull Set<String> excludedThreads, boolean shouldProfile, String integrationMode, long memoryUsageLimit, boolean heapSummaryEnabled, boolean allocationProfilingEnabled, int stackDepthLimit, @NonNull Duration samplingInterval, @NonNull Duration reportingInterval, boolean addProfilerOverheadAsSamples, @NonNull Duration minimumTimeForReporting, int dontReportIfSampledLessThanTimes) {
        if (profilingGroupName == null) {
            throw new NullPointerException("profilingGroupName is marked non-null but is null");
        }
        if (threadSupport == null) {
            throw new NullPointerException("threadSupport is marked non-null but is null");
        }
        if (excludedThreads == null) {
            throw new NullPointerException("excludedThreads is marked non-null but is null");
        }
        if (samplingInterval == null) {
            throw new NullPointerException("samplingInterval is marked non-null but is null");
        }
        if (reportingInterval == null) {
            throw new NullPointerException("reportingInterval is marked non-null but is null");
        }
        if (minimumTimeForReporting == null) {
            throw new NullPointerException("minimumTimeForReporting is marked non-null but is null");
        }
        this.profilingGroupName = profilingGroupName;
        this.threadSupport = threadSupport;
        this.excludedThreads = excludedThreads;
        this.shouldProfile = shouldProfile;
        this.integrationMode = integrationMode;
        this.memoryUsageLimit = memoryUsageLimit;
        this.heapSummaryEnabled = heapSummaryEnabled;
        this.allocationProfilingEnabled = allocationProfilingEnabled;
        this.stackDepthLimit = stackDepthLimit;
        this.samplingInterval = samplingInterval;
        this.reportingInterval = reportingInterval;
        this.addProfilerOverheadAsSamples = addProfilerOverheadAsSamples;
        this.minimumTimeForReporting = minimumTimeForReporting;
        this.dontReportIfSampledLessThanTimes = dontReportIfSampledLessThanTimes;
    }

    public static ProfilerParametersBuilder builder() {
        return new ProfilerParametersBuilder();
    }

    public ProfilerParametersBuilder toBuilder() {
        return new ProfilerParametersBuilder().profilingGroupName(this.profilingGroupName).threadSupport(this.threadSupport).excludedThreads(this.excludedThreads).shouldProfile(this.shouldProfile).integrationMode(this.integrationMode).memoryUsageLimit(this.memoryUsageLimit).heapSummaryEnabled(this.heapSummaryEnabled).allocationProfilingEnabled(this.allocationProfilingEnabled).stackDepthLimit(this.stackDepthLimit).samplingInterval(this.samplingInterval).reportingInterval(this.reportingInterval).addProfilerOverheadAsSamples(this.addProfilerOverheadAsSamples).minimumTimeForReporting(this.minimumTimeForReporting).dontReportIfSampledLessThanTimes(this.dontReportIfSampledLessThanTimes);
    }

    @NonNull
    public String getProfilingGroupName() {
        return this.profilingGroupName;
    }

    @NonNull
    public ThreadSupport getThreadSupport() {
        return this.threadSupport;
    }

    @NonNull
    public Set<String> getExcludedThreads() {
        return this.excludedThreads;
    }

    public boolean isShouldProfile() {
        return this.shouldProfile;
    }

    public String getIntegrationMode() {
        return this.integrationMode;
    }

    public long getMemoryUsageLimit() {
        return this.memoryUsageLimit;
    }

    public boolean isHeapSummaryEnabled() {
        return this.heapSummaryEnabled;
    }

    public boolean isAllocationProfilingEnabled() {
        return this.allocationProfilingEnabled;
    }

    public int getStackDepthLimit() {
        return this.stackDepthLimit;
    }

    @NonNull
    public Duration getSamplingInterval() {
        return this.samplingInterval;
    }

    @NonNull
    public Duration getReportingInterval() {
        return this.reportingInterval;
    }

    public boolean isAddProfilerOverheadAsSamples() {
        return this.addProfilerOverheadAsSamples;
    }

    @NonNull
    public Duration getMinimumTimeForReporting() {
        return this.minimumTimeForReporting;
    }

    public int getDontReportIfSampledLessThanTimes() {
        return this.dontReportIfSampledLessThanTimes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfilerParameters)) {
            return false;
        }
        ProfilerParameters other = (ProfilerParameters)o;
        if (this.isShouldProfile() != other.isShouldProfile()) {
            return false;
        }
        if (this.getMemoryUsageLimit() != other.getMemoryUsageLimit()) {
            return false;
        }
        if (this.isHeapSummaryEnabled() != other.isHeapSummaryEnabled()) {
            return false;
        }
        if (this.isAllocationProfilingEnabled() != other.isAllocationProfilingEnabled()) {
            return false;
        }
        if (this.getStackDepthLimit() != other.getStackDepthLimit()) {
            return false;
        }
        if (this.isAddProfilerOverheadAsSamples() != other.isAddProfilerOverheadAsSamples()) {
            return false;
        }
        if (this.getDontReportIfSampledLessThanTimes() != other.getDontReportIfSampledLessThanTimes()) {
            return false;
        }
        String this$profilingGroupName = this.getProfilingGroupName();
        String other$profilingGroupName = other.getProfilingGroupName();
        if (this$profilingGroupName == null ? other$profilingGroupName != null : !this$profilingGroupName.equals(other$profilingGroupName)) {
            return false;
        }
        ThreadSupport this$threadSupport = this.getThreadSupport();
        ThreadSupport other$threadSupport = other.getThreadSupport();
        if (this$threadSupport == null ? other$threadSupport != null : !this$threadSupport.equals(other$threadSupport)) {
            return false;
        }
        Set<String> this$excludedThreads = this.getExcludedThreads();
        Set<String> other$excludedThreads = other.getExcludedThreads();
        if (this$excludedThreads == null ? other$excludedThreads != null : !((Object)this$excludedThreads).equals(other$excludedThreads)) {
            return false;
        }
        String this$integrationMode = this.getIntegrationMode();
        String other$integrationMode = other.getIntegrationMode();
        if (this$integrationMode == null ? other$integrationMode != null : !this$integrationMode.equals(other$integrationMode)) {
            return false;
        }
        Duration this$samplingInterval = this.getSamplingInterval();
        Duration other$samplingInterval = other.getSamplingInterval();
        if (this$samplingInterval == null ? other$samplingInterval != null : !((Object)this$samplingInterval).equals(other$samplingInterval)) {
            return false;
        }
        Duration this$reportingInterval = this.getReportingInterval();
        Duration other$reportingInterval = other.getReportingInterval();
        if (this$reportingInterval == null ? other$reportingInterval != null : !((Object)this$reportingInterval).equals(other$reportingInterval)) {
            return false;
        }
        Duration this$minimumTimeForReporting = this.getMinimumTimeForReporting();
        Duration other$minimumTimeForReporting = other.getMinimumTimeForReporting();
        return !(this$minimumTimeForReporting == null ? other$minimumTimeForReporting != null : !((Object)this$minimumTimeForReporting).equals(other$minimumTimeForReporting));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShouldProfile() ? 79 : 97);
        long $memoryUsageLimit = this.getMemoryUsageLimit();
        result = result * 59 + (int)($memoryUsageLimit >>> 32 ^ $memoryUsageLimit);
        result = result * 59 + (this.isHeapSummaryEnabled() ? 79 : 97);
        result = result * 59 + (this.isAllocationProfilingEnabled() ? 79 : 97);
        result = result * 59 + this.getStackDepthLimit();
        result = result * 59 + (this.isAddProfilerOverheadAsSamples() ? 79 : 97);
        result = result * 59 + this.getDontReportIfSampledLessThanTimes();
        String $profilingGroupName = this.getProfilingGroupName();
        result = result * 59 + ($profilingGroupName == null ? 43 : $profilingGroupName.hashCode());
        ThreadSupport $threadSupport = this.getThreadSupport();
        result = result * 59 + ($threadSupport == null ? 43 : $threadSupport.hashCode());
        Set<String> $excludedThreads = this.getExcludedThreads();
        result = result * 59 + ($excludedThreads == null ? 43 : ((Object)$excludedThreads).hashCode());
        String $integrationMode = this.getIntegrationMode();
        result = result * 59 + ($integrationMode == null ? 43 : $integrationMode.hashCode());
        Duration $samplingInterval = this.getSamplingInterval();
        result = result * 59 + ($samplingInterval == null ? 43 : ((Object)$samplingInterval).hashCode());
        Duration $reportingInterval = this.getReportingInterval();
        result = result * 59 + ($reportingInterval == null ? 43 : ((Object)$reportingInterval).hashCode());
        Duration $minimumTimeForReporting = this.getMinimumTimeForReporting();
        result = result * 59 + ($minimumTimeForReporting == null ? 43 : ((Object)$minimumTimeForReporting).hashCode());
        return result;
    }

    public static class OverrideProfilerParameters {
        private final Optional<Boolean> shouldProfile;
        private final Optional<Long> memoryUsageLimit;
        private final Optional<Integer> stackDepthLimit;
        private final Optional<Duration> samplingInterval;
        private final Optional<Duration> reportingInterval;
        private final Optional<Duration> minimumTimeForReporting;
        private final Optional<Integer> dontReportIfSampledLessThanTimes;

        public void overlay(ProfilerParametersBuilder builder) {
            this.shouldProfile.ifPresent(x -> builder.shouldProfile((boolean)x));
            this.memoryUsageLimit.ifPresent(x -> builder.memoryUsageLimit((long)x));
            this.stackDepthLimit.ifPresent(x -> builder.stackDepthLimit((int)x));
            this.samplingInterval.ifPresent(x -> builder.samplingIntervalBounded((Duration)x));
            this.reportingInterval.ifPresent(x -> builder.reportingIntervalBounded((Duration)x));
            this.minimumTimeForReporting.ifPresent(x -> builder.minimumTimeForReporting((Duration)x));
            this.dontReportIfSampledLessThanTimes.ifPresent(x -> builder.dontReportIfSampledLessThanTimes((int)x));
        }

        private static Optional<Boolean> $default$shouldProfile() {
            return Optional.empty();
        }

        private static Optional<Long> $default$memoryUsageLimit() {
            return Optional.empty();
        }

        private static Optional<Integer> $default$stackDepthLimit() {
            return Optional.empty();
        }

        private static Optional<Duration> $default$samplingInterval() {
            return Optional.empty();
        }

        private static Optional<Duration> $default$reportingInterval() {
            return Optional.empty();
        }

        private static Optional<Duration> $default$minimumTimeForReporting() {
            return Optional.empty();
        }

        private static Optional<Integer> $default$dontReportIfSampledLessThanTimes() {
            return Optional.empty();
        }

        OverrideProfilerParameters(Optional<Boolean> shouldProfile, Optional<Long> memoryUsageLimit, Optional<Integer> stackDepthLimit, Optional<Duration> samplingInterval, Optional<Duration> reportingInterval, Optional<Duration> minimumTimeForReporting, Optional<Integer> dontReportIfSampledLessThanTimes) {
            this.shouldProfile = shouldProfile;
            this.memoryUsageLimit = memoryUsageLimit;
            this.stackDepthLimit = stackDepthLimit;
            this.samplingInterval = samplingInterval;
            this.reportingInterval = reportingInterval;
            this.minimumTimeForReporting = minimumTimeForReporting;
            this.dontReportIfSampledLessThanTimes = dontReportIfSampledLessThanTimes;
        }

        public static OverrideProfilerParametersBuilder builder() {
            return new OverrideProfilerParametersBuilder();
        }

        public Optional<Boolean> getShouldProfile() {
            return this.shouldProfile;
        }

        public Optional<Long> getMemoryUsageLimit() {
            return this.memoryUsageLimit;
        }

        public Optional<Integer> getStackDepthLimit() {
            return this.stackDepthLimit;
        }

        public Optional<Duration> getSamplingInterval() {
            return this.samplingInterval;
        }

        public Optional<Duration> getReportingInterval() {
            return this.reportingInterval;
        }

        public Optional<Duration> getMinimumTimeForReporting() {
            return this.minimumTimeForReporting;
        }

        public Optional<Integer> getDontReportIfSampledLessThanTimes() {
            return this.dontReportIfSampledLessThanTimes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OverrideProfilerParameters)) {
                return false;
            }
            OverrideProfilerParameters other = (OverrideProfilerParameters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<Boolean> this$shouldProfile = this.getShouldProfile();
            Optional<Boolean> other$shouldProfile = other.getShouldProfile();
            if (this$shouldProfile == null ? other$shouldProfile != null : !((Object)this$shouldProfile).equals(other$shouldProfile)) {
                return false;
            }
            Optional<Long> this$memoryUsageLimit = this.getMemoryUsageLimit();
            Optional<Long> other$memoryUsageLimit = other.getMemoryUsageLimit();
            if (this$memoryUsageLimit == null ? other$memoryUsageLimit != null : !((Object)this$memoryUsageLimit).equals(other$memoryUsageLimit)) {
                return false;
            }
            Optional<Integer> this$stackDepthLimit = this.getStackDepthLimit();
            Optional<Integer> other$stackDepthLimit = other.getStackDepthLimit();
            if (this$stackDepthLimit == null ? other$stackDepthLimit != null : !((Object)this$stackDepthLimit).equals(other$stackDepthLimit)) {
                return false;
            }
            Optional<Duration> this$samplingInterval = this.getSamplingInterval();
            Optional<Duration> other$samplingInterval = other.getSamplingInterval();
            if (this$samplingInterval == null ? other$samplingInterval != null : !((Object)this$samplingInterval).equals(other$samplingInterval)) {
                return false;
            }
            Optional<Duration> this$reportingInterval = this.getReportingInterval();
            Optional<Duration> other$reportingInterval = other.getReportingInterval();
            if (this$reportingInterval == null ? other$reportingInterval != null : !((Object)this$reportingInterval).equals(other$reportingInterval)) {
                return false;
            }
            Optional<Duration> this$minimumTimeForReporting = this.getMinimumTimeForReporting();
            Optional<Duration> other$minimumTimeForReporting = other.getMinimumTimeForReporting();
            if (this$minimumTimeForReporting == null ? other$minimumTimeForReporting != null : !((Object)this$minimumTimeForReporting).equals(other$minimumTimeForReporting)) {
                return false;
            }
            Optional<Integer> this$dontReportIfSampledLessThanTimes = this.getDontReportIfSampledLessThanTimes();
            Optional<Integer> other$dontReportIfSampledLessThanTimes = other.getDontReportIfSampledLessThanTimes();
            return !(this$dontReportIfSampledLessThanTimes == null ? other$dontReportIfSampledLessThanTimes != null : !((Object)this$dontReportIfSampledLessThanTimes).equals(other$dontReportIfSampledLessThanTimes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OverrideProfilerParameters;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<Boolean> $shouldProfile = this.getShouldProfile();
            result = result * 59 + ($shouldProfile == null ? 43 : ((Object)$shouldProfile).hashCode());
            Optional<Long> $memoryUsageLimit = this.getMemoryUsageLimit();
            result = result * 59 + ($memoryUsageLimit == null ? 43 : ((Object)$memoryUsageLimit).hashCode());
            Optional<Integer> $stackDepthLimit = this.getStackDepthLimit();
            result = result * 59 + ($stackDepthLimit == null ? 43 : ((Object)$stackDepthLimit).hashCode());
            Optional<Duration> $samplingInterval = this.getSamplingInterval();
            result = result * 59 + ($samplingInterval == null ? 43 : ((Object)$samplingInterval).hashCode());
            Optional<Duration> $reportingInterval = this.getReportingInterval();
            result = result * 59 + ($reportingInterval == null ? 43 : ((Object)$reportingInterval).hashCode());
            Optional<Duration> $minimumTimeForReporting = this.getMinimumTimeForReporting();
            result = result * 59 + ($minimumTimeForReporting == null ? 43 : ((Object)$minimumTimeForReporting).hashCode());
            Optional<Integer> $dontReportIfSampledLessThanTimes = this.getDontReportIfSampledLessThanTimes();
            result = result * 59 + ($dontReportIfSampledLessThanTimes == null ? 43 : ((Object)$dontReportIfSampledLessThanTimes).hashCode());
            return result;
        }

        public String toString() {
            return "ProfilerParameters.OverrideProfilerParameters(shouldProfile=" + this.getShouldProfile() + ", memoryUsageLimit=" + this.getMemoryUsageLimit() + ", stackDepthLimit=" + this.getStackDepthLimit() + ", samplingInterval=" + this.getSamplingInterval() + ", reportingInterval=" + this.getReportingInterval() + ", minimumTimeForReporting=" + this.getMinimumTimeForReporting() + ", dontReportIfSampledLessThanTimes=" + this.getDontReportIfSampledLessThanTimes() + ")";
        }

        public static class OverrideProfilerParametersBuilder {
            private boolean shouldProfile$set;
            private Optional<Boolean> shouldProfile$value;
            private boolean memoryUsageLimit$set;
            private Optional<Long> memoryUsageLimit$value;
            private boolean stackDepthLimit$set;
            private Optional<Integer> stackDepthLimit$value;
            private boolean samplingInterval$set;
            private Optional<Duration> samplingInterval$value;
            private boolean reportingInterval$set;
            private Optional<Duration> reportingInterval$value;
            private boolean minimumTimeForReporting$set;
            private Optional<Duration> minimumTimeForReporting$value;
            private boolean dontReportIfSampledLessThanTimes$set;
            private Optional<Integer> dontReportIfSampledLessThanTimes$value;

            OverrideProfilerParametersBuilder() {
            }

            public OverrideProfilerParametersBuilder shouldProfile(Optional<Boolean> shouldProfile) {
                this.shouldProfile$value = shouldProfile;
                this.shouldProfile$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder memoryUsageLimit(Optional<Long> memoryUsageLimit) {
                this.memoryUsageLimit$value = memoryUsageLimit;
                this.memoryUsageLimit$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder stackDepthLimit(Optional<Integer> stackDepthLimit) {
                this.stackDepthLimit$value = stackDepthLimit;
                this.stackDepthLimit$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder samplingInterval(Optional<Duration> samplingInterval) {
                this.samplingInterval$value = samplingInterval;
                this.samplingInterval$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder reportingInterval(Optional<Duration> reportingInterval) {
                this.reportingInterval$value = reportingInterval;
                this.reportingInterval$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder minimumTimeForReporting(Optional<Duration> minimumTimeForReporting) {
                this.minimumTimeForReporting$value = minimumTimeForReporting;
                this.minimumTimeForReporting$set = true;
                return this;
            }

            public OverrideProfilerParametersBuilder dontReportIfSampledLessThanTimes(Optional<Integer> dontReportIfSampledLessThanTimes) {
                this.dontReportIfSampledLessThanTimes$value = dontReportIfSampledLessThanTimes;
                this.dontReportIfSampledLessThanTimes$set = true;
                return this;
            }

            public OverrideProfilerParameters build() {
                Optional shouldProfile$value = this.shouldProfile$value;
                if (!this.shouldProfile$set) {
                    shouldProfile$value = OverrideProfilerParameters.$default$shouldProfile();
                }
                Optional memoryUsageLimit$value = this.memoryUsageLimit$value;
                if (!this.memoryUsageLimit$set) {
                    memoryUsageLimit$value = OverrideProfilerParameters.$default$memoryUsageLimit();
                }
                Optional stackDepthLimit$value = this.stackDepthLimit$value;
                if (!this.stackDepthLimit$set) {
                    stackDepthLimit$value = OverrideProfilerParameters.$default$stackDepthLimit();
                }
                Optional samplingInterval$value = this.samplingInterval$value;
                if (!this.samplingInterval$set) {
                    samplingInterval$value = OverrideProfilerParameters.$default$samplingInterval();
                }
                Optional reportingInterval$value = this.reportingInterval$value;
                if (!this.reportingInterval$set) {
                    reportingInterval$value = OverrideProfilerParameters.$default$reportingInterval();
                }
                Optional minimumTimeForReporting$value = this.minimumTimeForReporting$value;
                if (!this.minimumTimeForReporting$set) {
                    minimumTimeForReporting$value = OverrideProfilerParameters.$default$minimumTimeForReporting();
                }
                Optional dontReportIfSampledLessThanTimes$value = this.dontReportIfSampledLessThanTimes$value;
                if (!this.dontReportIfSampledLessThanTimes$set) {
                    dontReportIfSampledLessThanTimes$value = OverrideProfilerParameters.$default$dontReportIfSampledLessThanTimes();
                }
                return new OverrideProfilerParameters(shouldProfile$value, memoryUsageLimit$value, stackDepthLimit$value, samplingInterval$value, reportingInterval$value, minimumTimeForReporting$value, dontReportIfSampledLessThanTimes$value);
            }

            public String toString() {
                return "ProfilerParameters.OverrideProfilerParameters.OverrideProfilerParametersBuilder(shouldProfile$value=" + this.shouldProfile$value + ", memoryUsageLimit$value=" + this.memoryUsageLimit$value + ", stackDepthLimit$value=" + this.stackDepthLimit$value + ", samplingInterval$value=" + this.samplingInterval$value + ", reportingInterval$value=" + this.reportingInterval$value + ", minimumTimeForReporting$value=" + this.minimumTimeForReporting$value + ", dontReportIfSampledLessThanTimes$value=" + this.dontReportIfSampledLessThanTimes$value + ")";
            }
        }
    }

    public static class ProfilerParametersBuilder {
        private String profilingGroupName;
        private boolean threadSupport$set;
        private ThreadSupport threadSupport$value;
        private boolean excludedThreads$set;
        private Set<String> excludedThreads$value;
        private boolean shouldProfile$set;
        private boolean shouldProfile$value;
        private boolean integrationMode$set;
        private String integrationMode$value;
        private boolean memoryUsageLimit$set;
        private long memoryUsageLimit$value;
        private boolean heapSummaryEnabled$set;
        private boolean heapSummaryEnabled$value;
        private boolean allocationProfilingEnabled$set;
        private boolean allocationProfilingEnabled$value;
        private boolean stackDepthLimit$set;
        private int stackDepthLimit$value;
        private boolean samplingInterval$set;
        private Duration samplingInterval$value;
        private boolean reportingInterval$set;
        private Duration reportingInterval$value;
        private boolean addProfilerOverheadAsSamples$set;
        private boolean addProfilerOverheadAsSamples$value;
        private boolean minimumTimeForReporting$set;
        private Duration minimumTimeForReporting$value;
        private boolean dontReportIfSampledLessThanTimes$set;
        private int dontReportIfSampledLessThanTimes$value;

        public ProfilerParametersBuilder samplingIntervalBounded(Duration samplingInterval) {
            return this.samplingInterval(ProfilerParametersBuilder.boundDuration(samplingInterval));
        }

        public ProfilerParametersBuilder reportingIntervalBounded(Duration reportingInterval) {
            return this.reportingInterval(ProfilerParametersBuilder.boundDuration(reportingInterval));
        }

        private static Duration boundDuration(Duration input) {
            return input.toMillis() < 100L ? Duration.ofMillis(100L) : input;
        }

        public String getProfilingGroupName() {
            return this.profilingGroupName;
        }

        ProfilerParametersBuilder() {
        }

        public ProfilerParametersBuilder profilingGroupName(@NonNull String profilingGroupName) {
            if (profilingGroupName == null) {
                throw new NullPointerException("profilingGroupName is marked non-null but is null");
            }
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public ProfilerParametersBuilder threadSupport(@NonNull ThreadSupport threadSupport) {
            if (threadSupport == null) {
                throw new NullPointerException("threadSupport is marked non-null but is null");
            }
            this.threadSupport$value = threadSupport;
            this.threadSupport$set = true;
            return this;
        }

        public ProfilerParametersBuilder excludedThreads(@NonNull Set<String> excludedThreads) {
            if (excludedThreads == null) {
                throw new NullPointerException("excludedThreads is marked non-null but is null");
            }
            this.excludedThreads$value = excludedThreads;
            this.excludedThreads$set = true;
            return this;
        }

        public ProfilerParametersBuilder shouldProfile(boolean shouldProfile) {
            this.shouldProfile$value = shouldProfile;
            this.shouldProfile$set = true;
            return this;
        }

        public ProfilerParametersBuilder integrationMode(String integrationMode) {
            this.integrationMode$value = integrationMode;
            this.integrationMode$set = true;
            return this;
        }

        public ProfilerParametersBuilder memoryUsageLimit(long memoryUsageLimit) {
            this.memoryUsageLimit$value = memoryUsageLimit;
            this.memoryUsageLimit$set = true;
            return this;
        }

        public ProfilerParametersBuilder heapSummaryEnabled(boolean heapSummaryEnabled) {
            this.heapSummaryEnabled$value = heapSummaryEnabled;
            this.heapSummaryEnabled$set = true;
            return this;
        }

        public ProfilerParametersBuilder allocationProfilingEnabled(boolean allocationProfilingEnabled) {
            this.allocationProfilingEnabled$value = allocationProfilingEnabled;
            this.allocationProfilingEnabled$set = true;
            return this;
        }

        public ProfilerParametersBuilder stackDepthLimit(int stackDepthLimit) {
            this.stackDepthLimit$value = stackDepthLimit;
            this.stackDepthLimit$set = true;
            return this;
        }

        public ProfilerParametersBuilder samplingInterval(@NonNull Duration samplingInterval) {
            if (samplingInterval == null) {
                throw new NullPointerException("samplingInterval is marked non-null but is null");
            }
            this.samplingInterval$value = samplingInterval;
            this.samplingInterval$set = true;
            return this;
        }

        public ProfilerParametersBuilder reportingInterval(@NonNull Duration reportingInterval) {
            if (reportingInterval == null) {
                throw new NullPointerException("reportingInterval is marked non-null but is null");
            }
            this.reportingInterval$value = reportingInterval;
            this.reportingInterval$set = true;
            return this;
        }

        public ProfilerParametersBuilder addProfilerOverheadAsSamples(boolean addProfilerOverheadAsSamples) {
            this.addProfilerOverheadAsSamples$value = addProfilerOverheadAsSamples;
            this.addProfilerOverheadAsSamples$set = true;
            return this;
        }

        public ProfilerParametersBuilder minimumTimeForReporting(@NonNull Duration minimumTimeForReporting) {
            if (minimumTimeForReporting == null) {
                throw new NullPointerException("minimumTimeForReporting is marked non-null but is null");
            }
            this.minimumTimeForReporting$value = minimumTimeForReporting;
            this.minimumTimeForReporting$set = true;
            return this;
        }

        public ProfilerParametersBuilder dontReportIfSampledLessThanTimes(int dontReportIfSampledLessThanTimes) {
            this.dontReportIfSampledLessThanTimes$value = dontReportIfSampledLessThanTimes;
            this.dontReportIfSampledLessThanTimes$set = true;
            return this;
        }

        public ProfilerParameters build() {
            ThreadSupport threadSupport$value = this.threadSupport$value;
            if (!this.threadSupport$set) {
                threadSupport$value = ProfilerParameters.$default$threadSupport();
            }
            Set excludedThreads$value = this.excludedThreads$value;
            if (!this.excludedThreads$set) {
                excludedThreads$value = ProfilerParameters.$default$excludedThreads();
            }
            boolean shouldProfile$value = this.shouldProfile$value;
            if (!this.shouldProfile$set) {
                shouldProfile$value = ProfilerParameters.$default$shouldProfile();
            }
            String integrationMode$value = this.integrationMode$value;
            if (!this.integrationMode$set) {
                integrationMode$value = ProfilerParameters.$default$integrationMode();
            }
            long memoryUsageLimit$value = this.memoryUsageLimit$value;
            if (!this.memoryUsageLimit$set) {
                memoryUsageLimit$value = ProfilerParameters.$default$memoryUsageLimit();
            }
            boolean heapSummaryEnabled$value = this.heapSummaryEnabled$value;
            if (!this.heapSummaryEnabled$set) {
                heapSummaryEnabled$value = ProfilerParameters.$default$heapSummaryEnabled();
            }
            boolean allocationProfilingEnabled$value = this.allocationProfilingEnabled$value;
            if (!this.allocationProfilingEnabled$set) {
                allocationProfilingEnabled$value = ProfilerParameters.$default$allocationProfilingEnabled();
            }
            int stackDepthLimit$value = this.stackDepthLimit$value;
            if (!this.stackDepthLimit$set) {
                stackDepthLimit$value = ProfilerParameters.$default$stackDepthLimit();
            }
            Duration samplingInterval$value = this.samplingInterval$value;
            if (!this.samplingInterval$set) {
                samplingInterval$value = ProfilerParameters.$default$samplingInterval();
            }
            Duration reportingInterval$value = this.reportingInterval$value;
            if (!this.reportingInterval$set) {
                reportingInterval$value = ProfilerParameters.$default$reportingInterval();
            }
            boolean addProfilerOverheadAsSamples$value = this.addProfilerOverheadAsSamples$value;
            if (!this.addProfilerOverheadAsSamples$set) {
                addProfilerOverheadAsSamples$value = ProfilerParameters.$default$addProfilerOverheadAsSamples();
            }
            Duration minimumTimeForReporting$value = this.minimumTimeForReporting$value;
            if (!this.minimumTimeForReporting$set) {
                minimumTimeForReporting$value = ProfilerParameters.$default$minimumTimeForReporting();
            }
            int dontReportIfSampledLessThanTimes$value = this.dontReportIfSampledLessThanTimes$value;
            if (!this.dontReportIfSampledLessThanTimes$set) {
                dontReportIfSampledLessThanTimes$value = ProfilerParameters.$default$dontReportIfSampledLessThanTimes();
            }
            return new ProfilerParameters(this.profilingGroupName, threadSupport$value, excludedThreads$value, shouldProfile$value, integrationMode$value, memoryUsageLimit$value, heapSummaryEnabled$value, allocationProfilingEnabled$value, stackDepthLimit$value, samplingInterval$value, reportingInterval$value, addProfilerOverheadAsSamples$value, minimumTimeForReporting$value, dontReportIfSampledLessThanTimes$value);
        }

        public String toString() {
            return "ProfilerParameters.ProfilerParametersBuilder(profilingGroupName=" + this.profilingGroupName + ", threadSupport$value=" + this.threadSupport$value + ", excludedThreads$value=" + this.excludedThreads$value + ", shouldProfile$value=" + this.shouldProfile$value + ", integrationMode$value=" + this.integrationMode$value + ", memoryUsageLimit$value=" + this.memoryUsageLimit$value + ", heapSummaryEnabled$value=" + this.heapSummaryEnabled$value + ", allocationProfilingEnabled$value=" + this.allocationProfilingEnabled$value + ", stackDepthLimit$value=" + this.stackDepthLimit$value + ", samplingInterval$value=" + this.samplingInterval$value + ", reportingInterval$value=" + this.reportingInterval$value + ", addProfilerOverheadAsSamples$value=" + this.addProfilerOverheadAsSamples$value + ", minimumTimeForReporting$value=" + this.minimumTimeForReporting$value + ", dontReportIfSampledLessThanTimes$value=" + this.dontReportIfSampledLessThanTimes$value + ")";
        }
    }
}

