/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.codeguruprofilerjavaagent.profile.metadata;

import com.amazon.ion.IonWriter;
import com.amazonaws.services.lambda.runtime.Context;
import java.io.IOException;
import java.util.Optional;
import software.amazon.codeguruprofilerjavaagent.EnvironmentReader;
import software.amazon.codeguruprofilerjavaagent.profile.IonUtils;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInfo;
import software.amazon.codeguruprofilerjavaagent.profile.metadata.FleetInstanceType;
import software.amazon.codeguruprofilerjavaagent.utils.ext.StringUtils;

public class AWSLambda
implements FleetInfo {
    private static final String LAMBDA_MEMORY_SIZE = "AWS_LAMBDA_FUNCTION_MEMORY_SIZE";
    private static final String LAMBDA_EXECUTION_ENV = "AWS_EXECUTION_ENV";
    private final String functionArn;
    private final String memoryLimitInMB;
    private final String executionEnvironment;

    public static Optional<FleetInfo> lookUpMetadata(Context context, String invokedFunctionArn, EnvironmentReader environmentReader) {
        Optional<String> functionArn = AWSLambda.getLambdaFunctionArn(context, invokedFunctionArn);
        Optional<String> memoryLimitInMB = AWSLambda.lookUpMemoryLimit(environmentReader);
        Optional<String> executionEnvironment = AWSLambda.lookUpExecutionEnvironment(environmentReader);
        if (AWSLambda.isAvailable(functionArn) && AWSLambda.isAvailable(memoryLimitInMB) && AWSLambda.isAvailable(executionEnvironment)) {
            return Optional.of(new AWSLambda(functionArn.get(), memoryLimitInMB.get(), executionEnvironment.get()));
        }
        return Optional.empty();
    }

    private static Optional<String> lookUpMemoryLimit(EnvironmentReader environmentReader) {
        return Optional.ofNullable(environmentReader.get(LAMBDA_MEMORY_SIZE));
    }

    private static Optional<String> lookUpExecutionEnvironment(EnvironmentReader environmentReader) {
        return Optional.ofNullable(environmentReader.get(LAMBDA_EXECUTION_ENV));
    }

    private static boolean isAvailable(Optional<String> systemVariable) {
        return systemVariable.isPresent() && StringUtils.isNotBlank(systemVariable.get());
    }

    private static Optional<String> getLambdaFunctionArn(Context context, String invokedFunctionArn) {
        if (context != null) {
            return Optional.ofNullable(context.getInvokedFunctionArn());
        }
        if (invokedFunctionArn != null) {
            return Optional.of(invokedFunctionArn);
        }
        return Optional.empty();
    }

    @Override
    public void write(IonWriter out) throws IOException {
        IonUtils.writeStruct(out, () -> {
            IonUtils.writeString(out, "computeType", "aws_lambda");
            IonUtils.writeString(out, "functionArn", this.functionArn);
            IonUtils.writeString(out, "memoryLimitInMB", this.memoryLimitInMB);
            IonUtils.writeString(out, "executionEnv", this.executionEnvironment);
        });
    }

    @Override
    public String getFleetInstanceId() {
        return this.functionArn;
    }

    @Override
    public FleetInstanceType getFleetInstanceType() {
        return FleetInstanceType.AWSLambda;
    }

    public String toString() {
        return "AWSLambda{functionArn=" + this.functionArn + ", memoryLimitInMB=" + this.memoryLimitInMB + ", executionEnvironment=" + this.executionEnvironment + '}';
    }

    public AWSLambda(String functionArn, String memoryLimitInMB, String executionEnvironment) {
        this.functionArn = functionArn;
        this.memoryLimitInMB = memoryLimitInMB;
        this.executionEnvironment = executionEnvironment;
    }
}

