/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.MappingException;
import com.amazon.rdsdata.client.PropertyWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;

class FieldPropertyWriter
implements PropertyWriter {
    private Object instance;
    private Class<?> fieldType;
    private Field field;

    static Optional<PropertyWriter> fieldPropertyWriterFor(Object instance, String fieldName) {
        Class<?> instanceType = instance.getClass();
        try {
            Field field = FieldPropertyWriter.getField(instanceType, fieldName);
            if (Modifier.isStatic(field.getModifiers())) {
                throw MappingException.staticField(instanceType, fieldName);
            }
            FieldPropertyWriter writer = new FieldPropertyWriter(instance, field.getType(), field);
            return Optional.of(writer);
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    private static Field getField(Class<?> instanceType, String fieldName) throws NoSuchFieldException {
        try {
            return instanceType.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return instanceType.getDeclaredField(fieldName);
        }
    }

    @Override
    public void write(Object value) {
        try {
            this.field.set(this.instance, value);
        }
        catch (IllegalAccessException e) {
            throw MappingException.cannotAccessField(this.instance.getClass(), this.field.getName());
        }
    }

    @Override
    public Class<?> getType() {
        return this.fieldType;
    }

    private FieldPropertyWriter(Object instance, Class<?> fieldType, Field field) {
        this.instance = instance;
        this.fieldType = fieldType;
        this.field = field;
    }
}

