/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.FieldMapper;
import com.amazon.rdsdata.client.MappingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.UUID;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.rdsdata.model.Field;
import software.amazon.awssdk.services.rdsdata.model.TypeHint;

class TypeConverter {
    static String ERROR_PARAMETER_OF_UNKNOWN_TYPE = "Unknown parameter type: ";
    static DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSS]");
    static DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss[.SSS]");
    static DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    TypeConverter() {
    }

    static Field toField(Object o) {
        if (o == null || o == FieldMapper.NULL) {
            return (Field)Field.builder().isNull(Boolean.valueOf(true)).build();
        }
        if (o instanceof Byte || o instanceof Integer || o instanceof Long) {
            return (Field)Field.builder().longValue(Long.valueOf(((Number)o).longValue())).build();
        }
        if (o instanceof Double || o instanceof Float) {
            return (Field)Field.builder().doubleValue(Double.valueOf(((Number)o).doubleValue())).build();
        }
        if (o instanceof Character) {
            return (Field)Field.builder().longValue(Long.valueOf(((Character)o).charValue())).build();
        }
        if (o instanceof String) {
            return (Field)Field.builder().stringValue(o.toString()).build();
        }
        if (o instanceof Boolean) {
            return (Field)Field.builder().booleanValue((Boolean)o).build();
        }
        if (o instanceof byte[]) {
            return (Field)Field.builder().blobValue(SdkBytes.fromByteArray((byte[])((byte[])o))).build();
        }
        if (o instanceof BigDecimal || o instanceof BigInteger) {
            return (Field)Field.builder().stringValue(o.toString()).build();
        }
        if (o instanceof LocalDateTime) {
            return (Field)Field.builder().stringValue(DATE_TIME_FORMATTER.format((LocalDateTime)o)).build();
        }
        if (o instanceof LocalDate) {
            return (Field)Field.builder().stringValue(DATE_FORMATTER.format((LocalDate)o)).build();
        }
        if (o instanceof LocalTime) {
            return (Field)Field.builder().stringValue(TIME_FORMATTER.format((LocalTime)o)).build();
        }
        if (o instanceof Enum) {
            return (Field)Field.builder().stringValue(((Enum)o).name()).build();
        }
        if (o instanceof UUID) {
            return (Field)Field.builder().stringValue(o.toString()).build();
        }
        throw new IllegalArgumentException(ERROR_PARAMETER_OF_UNKNOWN_TYPE + o.getClass().getName());
    }

    static Optional<TypeHint> getTypeHint(Object o) {
        if (o instanceof BigDecimal || o instanceof BigInteger) {
            return Optional.of(TypeHint.DECIMAL);
        }
        if (o instanceof LocalDateTime) {
            return Optional.of(TypeHint.TIMESTAMP);
        }
        if (o instanceof LocalDate) {
            return Optional.of(TypeHint.DATE);
        }
        if (o instanceof LocalTime) {
            return Optional.of(TypeHint.TIME);
        }
        if (o instanceof UUID) {
            return Optional.of(TypeHint.UUID);
        }
        return Optional.empty();
    }

    static Object fromField(Field field, Class<?> type) {
        if (field.isNull() != null && field.isNull().booleanValue()) {
            return null;
        }
        if (type == String.class) {
            return field.stringValue();
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return field.longValue().byteValue();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return field.longValue().intValue();
        }
        if (type == Long.class || type == Long.TYPE) {
            return field.longValue();
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf((char)field.longValue().longValue());
        }
        if (type == Double.class || type == Double.TYPE) {
            return field.doubleValue();
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(field.doubleValue().floatValue());
        }
        if (type == byte[].class) {
            return field.blobValue().asByteArray();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return field.booleanValue();
        }
        if (type == BigDecimal.class) {
            return TypeConverter.toBigDecimal(field);
        }
        if (type == BigInteger.class) {
            return TypeConverter.toBigInteger(field);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Enum.valueOf(type, field.stringValue());
        }
        if (type == UUID.class) {
            return UUID.fromString(field.stringValue());
        }
        if (type == LocalDateTime.class) {
            return LocalDateTime.from(DATE_TIME_FORMATTER.parse(field.stringValue()));
        }
        if (type == LocalDate.class) {
            return TypeConverter.dateFromString(field.stringValue());
        }
        if (type == LocalTime.class) {
            return TypeConverter.timeFromString(field.stringValue());
        }
        return null;
    }

    private static LocalDate dateFromString(String dateString) {
        try {
            return LocalDate.from(DATE_TIME_FORMATTER.parse(dateString));
        }
        catch (DateTimeParseException e) {
            return LocalDate.from(DATE_FORMATTER.parse(dateString));
        }
    }

    private static LocalTime timeFromString(String timeString) {
        try {
            return LocalTime.from(DATE_TIME_FORMATTER.parse(timeString));
        }
        catch (DateTimeParseException e) {
            return LocalTime.from(TIME_FORMATTER.parse(timeString));
        }
    }

    private static BigDecimal toBigDecimal(Field field) {
        if (field.stringValue() != null) {
            return new BigDecimal(field.stringValue());
        }
        if (field.longValue() != null) {
            return BigDecimal.valueOf(field.longValue());
        }
        if (field.doubleValue() != null) {
            return BigDecimal.valueOf(field.doubleValue());
        }
        throw MappingException.cannotConvertToType(field, BigDecimal.class);
    }

    private static BigInteger toBigInteger(Field field) {
        if (field.stringValue() != null) {
            return new BigInteger(field.stringValue());
        }
        if (field.longValue() != null) {
            return BigInteger.valueOf(field.longValue());
        }
        throw MappingException.cannotConvertToType(field, BigInteger.class);
    }
}

