/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.api;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import uk.num.numlib.api.NumAPICallbacks;
import uk.num.numlib.api.NumAPIContext;
import uk.num.numlib.api.RequiredUserVariable;
import uk.num.numlib.exc.NumBadModuleConfigDataException;
import uk.num.numlib.exc.NumBadModuleIdException;
import uk.num.numlib.exc.NumBadMultipartRecordException;
import uk.num.numlib.exc.NumBadRecordException;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumDNSQueryException;
import uk.num.numlib.exc.NumException;
import uk.num.numlib.exc.NumInvalidDNSHostException;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumInvalidPopulatorResponseCodeException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.exc.NumMaximumRedirectsExceededException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.NumNotImplementedException;
import uk.num.numlib.exc.NumPopulatorErrorException;
import uk.num.numlib.internal.ctx.NumAPIContextBase;
import uk.num.numlib.internal.dns.DNSServices;
import uk.num.numlib.internal.dns.DNSServicesDefaultImpl;
import uk.num.numlib.internal.dns.PossibleMultiPartRecordException;
import uk.num.numlib.internal.modl.ModlServices;
import uk.num.numlib.internal.modl.NumLookupRedirect;
import uk.num.numlib.internal.modl.NumQueryRedirect;
import uk.num.numlib.internal.modl.PopulatorResponse;
import uk.num.numlib.internal.module.ModuleConfig;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.module.ModuleFactory;
import uk.num.numlib.internal.util.PopulatorRetryConfig;
import uk.num.numlib.internal.util.StringConstants;

public class NumAPI {
    public static final int MAX_NUM_REDIRECTS = 3;
    private static final Logger LOG = LoggerFactory.getLogger(NumAPI.class);
    private static final int MAX_NUMBER_OF_MULTI_PARTS = 30;
    private DNSServices dnsServices;
    private ModlServices modlServices;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public NumAPI() {
        LOG.info("enter - NumAPI()");
        this.dnsServices = new DNSServicesDefaultImpl();
        this.modlServices = new ModlServices();
        LOG.info("NumAPI object created.");
    }

    public NumAPI(DNSServices dnsServices, ModlServices modlServices) {
        LOG.info("enter - NumAPI(dnsServices, modlServices)");
        this.dnsServices = dnsServices;
        this.modlServices = modlServices;
        LOG.info("NumAPI object created.");
    }

    public NumAPI(String dnsHost) throws NumInvalidDNSHostException {
        this();
        LOG.info("enter - NumAPI({})", (Object)dnsHost);
        try {
            if (!StringUtils.isEmpty((CharSequence)dnsHost)) {
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                Lookup.setDefaultResolver((Resolver)resolver);
            }
        }
        catch (UnknownHostException e) {
            LOG.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        LOG.info("NumAPI object created.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NumAPI(String[] dnsHosts) throws NumInvalidDNSHostException, NumInvalidParameterException {
        this();
        LOG.info("enter - NumAPI({})", (Object)Arrays.toString(dnsHosts));
        if (dnsHosts == null || dnsHosts.length == 0) {
            LOG.error("No DNS hosts supplied.");
            throw new NumInvalidParameterException("No DNS hosts supplied.");
        }
        try {
            if (dnsHosts.length == 1) {
                String dnsHost = dnsHosts[0];
                if (StringUtils.isEmpty((CharSequence)dnsHost)) {
                    LOG.error("Empty hostname in the dnsHosts parameter.");
                    throw new NumInvalidDNSHostException("Empty hostname in the dnsHosts parameter.");
                }
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                Lookup.setDefaultResolver((Resolver)resolver);
            } else {
                ExtendedResolver resolver = new ExtendedResolver(dnsHosts);
                Lookup.setDefaultResolver((Resolver)resolver);
            }
        }
        catch (UnknownHostException e) {
            LOG.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        LOG.info("NumAPI object created.");
    }

    public NumAPI(String dnsHost, int port) throws NumInvalidDNSHostException {
        this();
        LOG.info("NumAPI({}, {})", (Object)dnsHost, (Object)port);
        try {
            if (!StringUtils.isEmpty((CharSequence)dnsHost)) {
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                resolver.setPort(port);
                Lookup.setDefaultResolver((Resolver)resolver);
                this.setTCPOnly(true);
            }
        }
        catch (UnknownHostException e) {
            LOG.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        LOG.info("NumAPI object created.");
    }

    public void setTCPOnly(boolean flag) {
        LOG.info("Use TCP only : {}", (Object)flag);
        Lookup.getDefaultResolver().setTCP(flag);
    }

    public void setTopLevelZone(String zone) {
        LOG.info("setTopLevelZone({})", (Object)zone);
        StringConstants.instance().setTopLevelZone(zone);
    }

    public NumAPIContext begin(String moduleId, String netString, int timeoutMillis) throws NumBadModuleIdException, NumBadModuleConfigDataException, NumBadURLException, NumInvalidParameterException, NumBadRecordException, NumDNSQueryException, NumInvalidDNSQueryException {
        LOG.info("enter - begin({}, {}, {})", new Object[]{moduleId, netString, timeoutMillis});
        assert (moduleId != null && moduleId.trim().length() > 0);
        assert (netString != null && netString.trim().length() > 0);
        assert (timeoutMillis > 0);
        NumAPIContextBase ctx = new NumAPIContextBase();
        ModuleDNSQueries moduleDNSQueries = ModuleFactory.getInstance(moduleId, netString);
        ctx.setModuleDNSQueries(moduleDNSQueries);
        Record[] records = this.dnsServices.getConfigFileTXTRecords(moduleId, timeoutMillis);
        if (records == null || records.length == 0) {
            LOG.error("No configuration moduleDNSQueries file available. Check that the moduleDNSQueries ID is correct.: {}", (Object)moduleId);
            throw new NumBadModuleIdException("No configuration moduleDNSQueries file available. Check that the moduleDNSQueries ID is correct.: " + moduleId);
        }
        String configTxt = this.dnsServices.rebuildTXTRecordContent(records).replaceAll("\\\\", "");
        ModuleConfig moduleConfig = this.modlServices.interpretModuleConfig(configTxt);
        if (!moduleConfig.isValid()) {
            LOG.error("The module config file is invalid. {}", (Object)configTxt);
            throw new NumBadModuleConfigDataException("Invalid module config data: " + configTxt);
        }
        ctx.setModuleConfig(moduleConfig);
        LOG.info("Module configuration: {}", (Object)moduleConfig);
        LOG.info("exit - begin()");
        return ctx;
    }

    public Future<String> retrieveNumRecord(NumAPIContext ctx, NumAPICallbacks handler, int timeoutMillis) {
        LOG.info("retrieveNumRecord()");
        assert (ctx != null);
        assert (handler != null);
        LOG.info("Submitting background query.");
        Future<String> future = this.executor.submit(() -> {
            while (true) {
                NumAPIContextBase context = (NumAPIContextBase)ctx;
                try {
                    ModuleConfig moduleConfig = context.getModuleConfig();
                    String jsonResult = this.getNumRecordFromIndependentLocation(timeoutMillis, context);
                    if (jsonResult == null) {
                        jsonResult = this.getNumRecordFromManagedLocation(timeoutMillis, context);
                        if (jsonResult != null) {
                            handler.setLocation(NumAPICallbacks.Location.MANAGED);
                        }
                        if (context.getModuleDNSQueries().isRootQuery()) {
                            if (jsonResult == null && moduleConfig.getModule().isRprq() && (jsonResult = this.getNumRecordFromPrepopulatedLocation(timeoutMillis, context)) != null) {
                                handler.setLocation(NumAPICallbacks.Location.POPULATED);
                            }
                            if (jsonResult == null && moduleConfig.getModule().isRpsq()) {
                                jsonResult = this.getNumRecordFromPopulator(timeoutMillis, context);
                            }
                        } else {
                            if (jsonResult == null && moduleConfig.getModule().isBprq() && (jsonResult = this.getNumRecordFromPrepopulatedLocation(timeoutMillis, context)) != null) {
                                handler.setLocation(NumAPICallbacks.Location.POPULATED);
                            }
                            if (jsonResult == null && moduleConfig.getModule().isBpsq()) {
                                jsonResult = this.getNumRecordFromPopulator(timeoutMillis, context);
                            }
                        }
                    } else {
                        handler.setLocation(NumAPICallbacks.Location.INDEPENDENT);
                    }
                    if (jsonResult != null && jsonResult.trim().length() > 0) {
                        handler.setResult(jsonResult);
                        LOG.info("NUM record retrieved and parsed successfully.");
                        LOG.debug("JSON result: {}", (Object)jsonResult);
                        return jsonResult;
                    }
                    LOG.error("Cannot retrieve the NUM record for module: {}", (Object)moduleConfig.getModule().getName());
                    handler.setErrorResult("Cannot retrieve the NUM record for module: " + moduleConfig.getModule().getName());
                }
                catch (NumException e) {
                    LOG.error("Cannot retrieve the NUM record for module.", (Throwable)e);
                    handler.setErrorResult("Cannot retrieve the NUM record for module: " + e.getLocalizedMessage());
                }
                catch (NumLookupRedirect numLookupRedirect) {
                    LOG.info("Lookup Redirecting to: {}", (Object)numLookupRedirect.getRedirect());
                    int redirectCount = context.incrementRedirectCount();
                    LOG.info("Redirect count: {}", (Object)redirectCount);
                    if (redirectCount >= 3) {
                        LOG.error("Maximum Redirects Exceeded. (max={})", (Object)3);
                        throw new NumMaximumRedirectsExceededException();
                    }
                    context.handleLookupRedirect(numLookupRedirect.getRedirect());
                    continue;
                }
                break;
            }
            LOG.error("Unable to retrieve a NUM record.");
            return null;
        });
        LOG.info("Background query running.");
        return future;
    }

    private String getNumRecordFromPrepopulatedLocation(int timeoutMillis, NumAPIContextBase context) throws NumBadMultipartRecordException, NumNotImplementedException, NumInvalidDNSQueryException, NumLookupRedirect, NumBadRecordException, NumMaximumRedirectsExceededException, NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException {
        LOG.info("getNumRecordFromPrepopulatedLocation()");
        String json = null;
        while (true) {
            String recordLocation = context.getModuleDNSQueries().getPrepopulatedRecordLocation();
            LOG.info("Looking for Pre-populated record at: {}", (Object)recordLocation);
            String numRecord = this.getNumRecord(timeoutMillis, context, recordLocation);
            if (numRecord == null || numRecord.trim().length() <= 0) break;
            LOG.info("Found NUM record at Populated location.");
            try {
                json = this.interpretNumRecord(numRecord, context);
            }
            catch (NumQueryRedirect numQueryRedirect) {
                LOG.info("Query Redirected to: {}", (Object)numQueryRedirect.getRedirect());
                int redirectCount = context.incrementRedirectCount();
                if (redirectCount >= 3) {
                    LOG.error("Maximum Redirects Exceeded. (max={})", (Object)3);
                    throw new NumMaximumRedirectsExceededException();
                }
                context.handlePrepopulatedQueryRedirect(numQueryRedirect.getRedirect());
                continue;
            }
            break;
        }
        return json;
    }

    private Record[] getMultiPartRecords(int timeoutMillis, NumAPIContextBase context, String recordLocation) throws NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException {
        LOG.info("getMultiPartRecords(recordLocation={})", (Object)recordLocation);
        Record[] numberOfPartsRecord = this.dnsServices.getRecordFromDns("0." + recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
        if (numberOfPartsRecord == null || numberOfPartsRecord.length == 0) {
            return null;
        }
        String numberOfPartsStr = this.dnsServices.rebuildTXTRecordContent(numberOfPartsRecord);
        if (!numberOfPartsStr.startsWith("parts=")) {
            throw new NumBadMultipartRecordException("Invalid record 0 for multi-part record: " + numberOfPartsStr);
        }
        int numberOfParts = Integer.parseInt(numberOfPartsStr.substring(6));
        if (numberOfParts > 30) {
            throw new NumBadMultipartRecordException("Too many parts for a multi-part record: " + numberOfPartsStr);
        }
        ArrayList<Record> parts = new ArrayList<Record>();
        for (int i = 1; i <= numberOfParts; ++i) {
            Record[] partNRecords = this.dnsServices.getRecordFromDns("" + i + "." + recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
            if (partNRecords == null || partNRecords.length <= 0) continue;
            parts.addAll(Arrays.asList(partNRecords));
        }
        Record[] recordFromDns = parts.toArray(new Record[0]);
        return recordFromDns;
    }

    private String getNumRecordFromPopulator(int timeoutMillis, NumAPIContextBase context) throws NumPopulatorErrorException, NumNoRecordAvailableException, NumInvalidPopulatorResponseCodeException, NumBadMultipartRecordException, NumBadRecordException, NumNotImplementedException, NumInvalidDNSQueryException, NumLookupRedirect, NumMaximumRedirectsExceededException, NumInvalidParameterException, NumBadURLException, NumInvalidRedirectException {
        LOG.info("getNumRecordFromPopulator()");
        String recordLocation = context.getModuleDNSQueries().getPopulatorLocation();
        LOG.info("Querying the populator service: {}", (Object)recordLocation);
        String numRecord = null;
        while (numRecord == null && (numRecord = this.getNumRecordNoCache(timeoutMillis, context, recordLocation)) != null) {
            LOG.info("Response from Populator: {}.", (Object)numRecord);
            PopulatorResponse response = this.modlServices.interpretPopulatorResponse(numRecord);
            if (!response.isValid()) {
                throw new NumInvalidPopulatorResponseCodeException("Bad response received from the populator service.");
            }
            if (response.getStatus_() != null) {
                numRecord = this.handlePopulatorStatusCodes(timeoutMillis, context, response);
            }
            if (response.getError_() == null) continue;
            if (response.getError_().getCode() == 100) {
                LOG.error("NUM Populator error: {}, {}", (Object)response.getError_().getCode(), (Object)response.getError_().getDescription());
                try {
                    for (int i = 0; i < PopulatorRetryConfig.ERROR_RETRIES; ++i) {
                        LOG.info("Sleeping for {} seconds.", (Object)PopulatorRetryConfig.ERROR_RETRY_DELAYS[i]);
                        TimeUnit.SECONDS.sleep(PopulatorRetryConfig.ERROR_RETRY_DELAYS[i]);
                        LOG.info("Retrying...");
                        numRecord = this.getNumRecord(timeoutMillis, context, recordLocation);
                        PopulatorResponse retryResponse = this.modlServices.interpretPopulatorResponse(numRecord);
                        if (retryResponse.getStatus_() == null) continue;
                        return this.handlePopulatorStatusCodes(timeoutMillis, context, retryResponse);
                    }
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted", (Throwable)e);
                }
                LOG.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            LOG.error("NUM Populator error: {}, {}", (Object)response.getError_().getCode(), (Object)response.getError_().getDescription());
            throw new NumPopulatorErrorException(response.getError_().getDescription());
        }
        return numRecord;
    }

    private String handlePopulatorStatusCodes(int timeoutMillis, NumAPIContextBase context, PopulatorResponse response) throws NumNoRecordAvailableException, NumInvalidPopulatorResponseCodeException, NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException, NumLookupRedirect, NumBadRecordException, NumMaximumRedirectsExceededException, NumBadURLException, NumInvalidParameterException, NumInvalidRedirectException {
        LOG.info("handlePopulatorStatusCodes()");
        String numRecord = null;
        switch (response.getStatus_().getCode()) {
            case 1: {
                LOG.info("Populator Status code: 1");
                try {
                    for (int i = 0; i < PopulatorRetryConfig.RETRIES; ++i) {
                        LOG.info("Sleeping for {} seconds.", (Object)PopulatorRetryConfig.RETRY_DELAYS[i]);
                        TimeUnit.SECONDS.sleep(PopulatorRetryConfig.RETRY_DELAYS[i]);
                        LOG.info("Retrying...");
                        numRecord = this.getNumRecordFromPrepopulatedLocation(timeoutMillis, context);
                        if (numRecord != null) break;
                    }
                    LOG.error("Cannot retrieve NUM record from any location.");
                    throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            case 2: {
                LOG.info("Populator Status code: 2");
                numRecord = this.getNumRecordFromIndependentLocation(timeoutMillis, context);
                if (numRecord != null) break;
                LOG.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            case 3: {
                LOG.info("Populator Status code: 3");
                numRecord = this.getNumRecordFromManagedLocation(timeoutMillis, context);
                if (numRecord != null) break;
                LOG.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            default: {
                LOG.error("Invalid response code from DNS populator service: {}", (Object)response.getStatus_().getCode());
                throw new NumInvalidPopulatorResponseCodeException("Invalid response code from DNS populator service: " + response.getStatus_().getCode());
            }
        }
        return numRecord;
    }

    private String getNumRecordFromManagedLocation(int timeoutMillis, NumAPIContextBase context) throws NumBadMultipartRecordException, NumNotImplementedException, NumInvalidDNSQueryException, NumLookupRedirect, NumBadRecordException, NumMaximumRedirectsExceededException, NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException {
        LOG.info("getNumRecordFromManagedLocation()");
        String json = null;
        while (true) {
            String recordLocation = context.getModuleDNSQueries().getManagedRecordLocation();
            LOG.info("Looking for managed record at: {}", (Object)recordLocation);
            String numRecord = this.getNumRecord(timeoutMillis, context, recordLocation);
            if (numRecord == null || numRecord.trim().length() <= 0) break;
            LOG.info("Found NUM record at Managed location.");
            try {
                json = this.interpretNumRecord(numRecord, context);
            }
            catch (NumQueryRedirect numQueryRedirect) {
                LOG.info("Query Redirected to: {}", (Object)numQueryRedirect.getRedirect());
                int redirectCount = context.incrementRedirectCount();
                if (redirectCount >= 3) {
                    LOG.error("Maximum Redirects Exceeded. (max={})", (Object)3);
                    throw new NumMaximumRedirectsExceededException();
                }
                context.handleManagedQueryRedirect(numQueryRedirect.getRedirect());
                continue;
            }
            break;
        }
        return json;
    }

    private String getInterpretedNumRecordAsJson(String moduleNumber, ModuleConfig moduleConfig, String numRecord) throws NumBadRecordException, NumQueryRedirect, NumLookupRedirect {
        LOG.info("getInterpretedNumRecordAsJson({}, moduleConfig, {})", (Object)moduleNumber, (Object)numRecord);
        StringBuilder numRecordBuffer = new StringBuilder();
        RequiredUserVariable[] ruv = moduleConfig.getModule().getRuv();
        if (ruv != null) {
            for (RequiredUserVariable v : ruv) {
                numRecordBuffer.append(v.getKey());
                numRecordBuffer.append("=");
                numRecordBuffer.append(v.getValue());
                numRecordBuffer.append(";");
            }
        }
        numRecordBuffer.append("*load=\"http://modules.num.uk/");
        numRecordBuffer.append(moduleNumber);
        numRecordBuffer.append("/rcf.txt!\";");
        numRecordBuffer.append(numRecord);
        LOG.info("Interpret NUM record: {}", (Object)numRecordBuffer.toString());
        return this.modlServices.interpretNumRecord(numRecordBuffer.toString());
    }

    private String getNumRecordFromIndependentLocation(int timeoutMillis, NumAPIContextBase context) throws NumBadMultipartRecordException, NumNotImplementedException, NumInvalidDNSQueryException, NumLookupRedirect, NumBadRecordException, NumMaximumRedirectsExceededException, NumInvalidParameterException, NumBadURLException, NumInvalidRedirectException {
        LOG.info("getNumRecordFromIndependentLocation()");
        String json = null;
        while (true) {
            String recordLocation = context.getModuleDNSQueries().getIndependentRecordLocation();
            LOG.info("Looking for Independent record at: {}", (Object)recordLocation);
            String numRecord = this.getNumRecord(timeoutMillis, context, recordLocation);
            if (numRecord == null || numRecord.trim().length() <= 0) break;
            LOG.info("Found NUM record at Independent location.");
            try {
                json = this.interpretNumRecord(numRecord, context);
            }
            catch (NumQueryRedirect numQueryRedirect) {
                LOG.info("Query Redirected to: {}", (Object)numQueryRedirect.getRedirect());
                int redirectCount = context.incrementRedirectCount();
                if (redirectCount >= 3) {
                    LOG.error("Maximum Redirects Exceeded. (max={})", (Object)3);
                    throw new NumMaximumRedirectsExceededException();
                }
                context.handleIndependentQueryRedirect(numQueryRedirect.getRedirect());
                continue;
            }
            break;
        }
        return json;
    }

    private String interpretNumRecord(String numRecord, NumAPIContextBase context) throws NumLookupRedirect, NumBadRecordException, NumQueryRedirect {
        LOG.info("interpretNumRecord({}, context)", (Object)numRecord);
        String json = null;
        if (numRecord != null && numRecord.trim().length() > 0) {
            json = this.getInterpretedNumRecordAsJson(context.getModuleDNSQueries().getModuleId(), context.getModuleConfig(), numRecord);
        }
        return json;
    }

    private String getNumRecord(int timeoutMillis, NumAPIContextBase context, String recordLocation) throws NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException {
        Record[] recordFromDns;
        LOG.info("getNumRecord({}, context, {})", (Object)timeoutMillis, (Object)recordLocation);
        try {
            recordFromDns = this.dnsServices.getRecordFromDns(recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
        }
        catch (PossibleMultiPartRecordException e) {
            LOG.info("Possible multi-part record - checking.");
            recordFromDns = this.getMultiPartRecords(timeoutMillis, context, recordLocation);
        }
        if (recordFromDns == null || recordFromDns.length == 0) {
            return null;
        }
        return this.dnsServices.rebuildTXTRecordContent(recordFromDns);
    }

    private String getNumRecordNoCache(int timeoutMillis, NumAPIContextBase context, String recordLocation) throws NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException {
        Record[] recordFromDns;
        LOG.info("getNumRecordNoCache({}, context, {})", (Object)timeoutMillis, (Object)recordLocation);
        try {
            recordFromDns = this.dnsServices.getRecordFromDnsNoCache(recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
        }
        catch (PossibleMultiPartRecordException e) {
            LOG.info("Possible multi-part record - checking.");
            recordFromDns = this.getMultiPartRecords(timeoutMillis, context, recordLocation);
        }
        if (recordFromDns == null || recordFromDns.length == 0) {
            return null;
        }
        return this.dnsServices.rebuildTXTRecordContent(recordFromDns);
    }

    public void shutdown() {
        LOG.info("shutdown()");
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Shutdown interrupted: ", (Throwable)e);
        }
        finally {
            if (!this.executor.isTerminated()) {
                LOG.info("Failed to shutdown after 1 second, so forcing shutdown.");
                this.executor.shutdownNow();
            }
        }
        LOG.info("Shutdown complete.");
    }
}

