/*
 * Decompiled with CFR 0.152.
 */
package uk.num.validators;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class ValidationResult {
    public static final ValidationResult VALID_NO_ERRORS = new ValidationResult();
    private final List<Result> errors = new ArrayList<Result>();

    public void addMessage(@NonNull ErrorCode code, String offendingPart) {
        if (code == null) {
            throw new NullPointerException("code is marked @NonNull but is null");
        }
        String part = offendingPart == null ? "null" : offendingPart;
        this.errors.add(new Result(code, part));
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    public void merge(@NonNull ValidationResult other) {
        if (other == null) {
            throw new NullPointerException("other is marked @NonNull but is null");
        }
        this.errors.addAll(other.errors);
    }

    public List<Result> getErrors() {
        return this.errors;
    }

    public static final class Result {
        @NonNull
        private final ErrorCode code;
        @NonNull
        private final String offendingPart;

        public Result(@NonNull ErrorCode code, @NonNull String offendingPart) {
            if (code == null) {
                throw new NullPointerException("code is marked @NonNull but is null");
            }
            if (offendingPart == null) {
                throw new NullPointerException("offendingPart is marked @NonNull but is null");
            }
            this.code = code;
            this.offendingPart = offendingPart;
        }

        @NonNull
        public ErrorCode getCode() {
            return this.code;
        }

        @NonNull
        public String getOffendingPart() {
            return this.offendingPart;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            ErrorCode this$code = this.getCode();
            ErrorCode other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)((Object)this$code)).equals((Object)other$code)) {
                return false;
            }
            String this$offendingPart = this.getOffendingPart();
            String other$offendingPart = other.getOffendingPart();
            return !(this$offendingPart == null ? other$offendingPart != null : !this$offendingPart.equals(other$offendingPart));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ErrorCode $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)((Object)$code)).hashCode());
            String $offendingPart = this.getOffendingPart();
            result = result * 59 + ($offendingPart == null ? 43 : $offendingPart.hashCode());
            return result;
        }

        public String toString() {
            return "ValidationResult.Result(code=" + (Object)((Object)this.getCode()) + ", offendingPart=" + this.getOffendingPart() + ")";
        }
    }

    public static enum ErrorCode {
        INVALID_NUM_PROTOCOL_PREFIX,
        TOO_MANY_COLONS,
        EXCEPTION_MESSAGE,
        DOMAIN_NAME_TOO_LONG,
        ZERO_LENGTH_LABEL,
        LABEL_TOO_LONG,
        SPACES_IN_LABEL,
        FORM_FEED_IN_LABEL,
        TAB_IN_LABEL,
        CARRIAGE_RETURN_IN_LABEL,
        BACKSPACE_IN_LABEL,
        NEWLINE_IN_LABEL,
        PATTERN_MISMATCH,
        NO_AT_SYMBOL,
        TOO_MANY_AT_SYMBOLS,
        LOCAL_PART_OF_EMAIL_TOO_LONG,
        LOCAL_PART_OF_EMAIL_IS_EMPTY,
        PATH_MUST_START_WITH_SLASH,
        ZERO_LENGTH_PATH_COMPONENT,
        PATH_COMPONENT_TOO_LONG,
        NEGATIVE_MODULE_NUMBER,
        HOSTED_DOMAIN_NAME_TOO_LONG,
        INDEPENDENT_DOMAIN_NAME_TOO_LONG,
        INVALID_MODULE_NUMBER,
        PATH_COMPONENT_CONTAINS_SPACE,
        PATH_COMPONENT_CONTAINS_FORMFEED,
        PATH_COMPONENT_CONTAINS_BACKSPACE,
        PATH_COMPONENT_CONTAINS_TAB,
        PATH_COMPONENT_CONTAINS_CARRIAGE_RETURN,
        PATH_COMPONENT_CONTAINS_NEWLINE,
        LOCAL_PART_OF_EMAIL_CONTAINS_NEWLINE,
        LOCAL_PART_OF_EMAIL_CONTAINS_CARRIAGE_RETURN,
        LOCAL_PART_OF_EMAIL_CONTAINS_TAB,
        LOCAL_PART_OF_EMAIL_CONTAINS_BACKSPACE,
        LOCAL_PART_OF_EMAIL_CONTAINS_FORMFEED,
        LOCAL_PART_OF_EMAIL_CONTAINS_DOUBLE_DOT,
        LOCAL_PART_OF_EMAIL_CONTAINS_STARTS_WITH_DOT,
        LOCAL_PART_OF_EMAIL_CONTAINS_ENDS_WITH_DOT,
        HYPHEN_AT_END_OF_DOMAIN,
        HYPHEN_AT_START_OF_DOMAIN,
        LOCAL_PART_OF_EMAIL_CONTAINS_DOUBLE_QUOTE,
        NULL_UNACCEPTABLE;

    }
}

