/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.util;

import java.math.BigInteger;
import org.apache.commons.codec.digest.DigestUtils;

public final class HashUtils {
    public static String hash(String normalisedDomain, int levels) {
        switch (levels) {
            case 1: {
                return HashUtils.hash1(normalisedDomain);
            }
            case 2: {
                return HashUtils.hash2(normalisedDomain);
            }
            case 3: {
                return HashUtils.hash3(normalisedDomain);
            }
        }
        throw new RuntimeException("Invalid number of levels in Zone Distribution Record: " + levels);
    }

    public static String domainAndHash(String domain) {
        return domain + HashUtils.hash3(domain);
    }

    public static String hash1(String normalisedDomain) {
        String result = HashUtils.hashString(normalisedDomain);
        return "." + result.charAt(0);
    }

    public static String hash2(String normalisedDomain) {
        String result = HashUtils.hashString(normalisedDomain);
        return String.format(".%s.%s", Character.valueOf(result.charAt(1)), Character.valueOf(result.charAt(0)));
    }

    private static String hashString(String s) {
        return new BigInteger(1, DigestUtils.sha1((String)s)).toString(36);
    }

    public static String hash3(String normalisedDomain) {
        String result = HashUtils.hashString(normalisedDomain);
        return String.format(".%s.%s.%s", Character.valueOf(result.charAt(2)), Character.valueOf(result.charAt(1)), Character.valueOf(result.charAt(0)));
    }
}

