/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.util;

import lombok.NonNull;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.internal.util.BaseLookupGenerator;
import uk.num.numlib.internal.util.HashUtils;
import uk.num.numlib.internal.util.LookupGenerator;
import uk.num.numlib.internal.util.StringConstants;

public final class EmailLookupGenerator
extends BaseLookupGenerator
implements LookupGenerator {
    public final String localPart;

    public EmailLookupGenerator(@NonNull String numId) {
        super(numId);
        if (numId == null) {
            throw new NullPointerException("numId is marked @NonNull but is null");
        }
        int atIndex = numId.indexOf(64);
        this.localPart = numId.substring(0, atIndex);
        int slashIndex = numId.indexOf("/");
        if (slashIndex > -1) {
            this.domain = EmailLookupGenerator.normaliseDomainName(numId.substring(atIndex + 1, slashIndex));
            this.branch = this.transformBranch(numId.substring(slashIndex));
        } else {
            this.domain = EmailLookupGenerator.normaliseDomainName(numId.substring(atIndex + 1));
        }
    }

    @Override
    public String getIndependentLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        String result = this.getRootIndependentLocation(moduleNumber);
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    @Override
    public String getHostedLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        String result = this.getRootHostedLocation(moduleNumber);
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    @Override
    public String getPopulatorLocation(int moduleId) {
        return null;
    }

    @Override
    public String getRootIndependentLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        return moduleNumber + "." + "_" + this.localPart + "." + "e" + "._num." + this.domain + ".";
    }

    @Override
    public String getRootHostedLocation(int moduleNumber) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        return moduleNumber + "." + "_" + this.localPart + "." + "e" + "." + "_" + this.domain + HashUtils.hash3(this.domain) + StringConstants.HOSTED_RECORD_SUFFIX + ".";
    }

    public String getDistributedIndependentLocation(int moduleNumber, int levels) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        String emailLocalPartHash = HashUtils.hash(this.localPart, levels);
        String result = moduleNumber + "." + "_" + this.localPart + emailLocalPartHash + "." + "e" + "._num." + this.domain + ".";
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    public String getDistributedHostedLocation(int moduleNumber, int levels) throws NumInvalidParameterException {
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        String emailLocalPartHash = HashUtils.hash(this.localPart, levels);
        String result = moduleNumber + "." + "_" + this.localPart + emailLocalPartHash + "." + "e" + "." + "_" + this.domain + HashUtils.hash3(this.domain) + StringConstants.HOSTED_RECORD_SUFFIX + ".";
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }
}

