/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.ctx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.num.numlib.api.NumAPICallbacks;
import uk.num.numlib.api.NumAPIContext;
import uk.num.numlib.api.UserVariable;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.exc.NumMaximumRedirectsExceededException;
import uk.num.numlib.exc.RelativePathException;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.util.UrlRelativePathResolver;

public class NumAPIContextBase
implements NumAPIContext {
    private static final Logger log = LogManager.getLogger(NumAPIContextBase.class);
    private static final int MAX_NUM_REDIRECTS = 3;
    private boolean populatorQueryRequired = false;
    private UserVariable[] requiredUserVariables;
    private ModuleDNSQueries moduleDNSQueries;
    private int redirectCount = 0;
    private NumAPICallbacks.Location location;

    private int incrementRedirectCount() {
        ++this.redirectCount;
        return this.redirectCount;
    }

    public String getRecordLocation() {
        switch (this.location) {
            case INDEPENDENT: {
                return this.moduleDNSQueries.getIndependentRecordLocation();
            }
            case HOSTED: {
                return this.moduleDNSQueries.getHostedRecordLocation();
            }
            case POPULATOR: {
                return this.moduleDNSQueries.getPopulatorLocation();
            }
        }
        return "STOP";
    }

    public void handleQueryRedirect(String redirect, NumAPIContextBase context) throws NumMaximumRedirectsExceededException, NumInvalidDNSQueryException, NumInvalidRedirectException {
        log.info("Query Redirected to: {}", (Object)redirect);
        int redirectCount = context.incrementRedirectCount();
        if (redirectCount >= 3) {
            log.error("Maximum Redirects Exceeded. (max={})", (Object)3);
            throw new NumMaximumRedirectsExceededException();
        }
        switch (this.location) {
            case INDEPENDENT: {
                this.handleIndependentQueryRedirect(redirect);
            }
            case HOSTED: {
                this.handleHostedQueryRedirect(redirect);
            }
        }
    }

    private void handleHostedQueryRedirect(String redirectTo) throws NumInvalidDNSQueryException, NumInvalidRedirectException {
        String hostedRecordPath = this.moduleDNSQueries.getHostedRecordPath();
        try {
            this.moduleDNSQueries.redirectHostedPath(UrlRelativePathResolver.resolve(hostedRecordPath, redirectTo));
        }
        catch (RelativePathException e) {
            throw new NumInvalidRedirectException((Throwable)((Object)e));
        }
    }

    private void handleIndependentQueryRedirect(String redirectTo) throws NumInvalidRedirectException, NumInvalidDNSQueryException {
        String independentRecordPath = this.moduleDNSQueries.getIndependentRecordPath();
        try {
            this.moduleDNSQueries.redirectIndependentPath(UrlRelativePathResolver.resolve(independentRecordPath, redirectTo));
        }
        catch (RelativePathException e) {
            throw new NumInvalidRedirectException((Throwable)((Object)e));
        }
    }

    @Override
    public UserVariable[] getRequiredUserVariables() {
        if (this.requiredUserVariables == null) {
            return new UserVariable[0];
        }
        return this.requiredUserVariables;
    }

    @Override
    public void setRequiredUserVariables(UserVariable[] uv) {
        this.requiredUserVariables = uv;
    }

    @Override
    public boolean isPopulatorQueryRequired() {
        return this.populatorQueryRequired;
    }

    @Override
    public void setPopulatorQueryRequired(boolean populatorQueryRequired) {
        this.populatorQueryRequired = populatorQueryRequired;
    }

    public ModuleDNSQueries getModuleDNSQueries() {
        return this.moduleDNSQueries;
    }

    public void setModuleDNSQueries(ModuleDNSQueries moduleDNSQueries) {
        this.moduleDNSQueries = moduleDNSQueries;
    }

    public NumAPICallbacks.Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(NumAPICallbacks.Location location) {
        this.location = location;
    }
}

