/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.util;

import java.util.HashMap;
import java.util.Map;

public final class SimpleCache<K, V> {
    private static final int TEN_MINUTES = 600000;
    private final Map<K, CacheEntry<V>> cache = new HashMap<K, CacheEntry<V>>();
    private int millis = 600000;

    public void setTimeToLive(int millis) {
        this.millis = millis;
    }

    public void put(K key, V value) {
        CacheEntry<V> entry = new CacheEntry<V>(value, (long)this.millis + System.currentTimeMillis());
        this.cache.put(key, entry);
    }

    public V get(K key) {
        CacheEntry<V> entry = this.cache.get(key);
        if (entry == null || ((CacheEntry)entry).expiry < System.currentTimeMillis()) {
            if (entry != null) {
                this.cache.remove(key);
            }
            return null;
        }
        return (V)((CacheEntry)entry).value;
    }

    private static class CacheEntry<V> {
        private final V value;
        private final long expiry;

        CacheEntry(V value, long expiry) {
            this.value = value;
            this.expiry = expiry;
        }
    }
}

