/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.alert;

import ch.weetech.alert.Email;
import java.io.File;

public class EmailAttachment
extends Email {
    private File file;
    private String content;
    private String name;
    private String contentType;
    private String contentTransferEncoding;

    private EmailAttachment(Builder builder) {
        this.file = builder.file;
        this.content = builder.content;
        this.name = builder.name;
        this.contentType = builder.contentType;
        this.contentTransferEncoding = builder.contentTransferEncoding;
    }

    public File getFile() {
        return this.file;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    public static class Builder {
        private File file;
        private String content;
        private String name;
        private String contentType;
        private String contentTransferEncoding;

        public Builder(File file) {
            this.file = file;
        }

        public Builder(String content) {
            this.content = content;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentTransferEncoding(String contentTransferEncoding) {
            this.contentTransferEncoding = contentTransferEncoding;
            return this;
        }

        public EmailAttachment build() {
            this.validate();
            return new EmailAttachment(this);
        }

        private void validate() throws IllegalStateException {
            if (this.file == null && this.content == null) {
                throw new IllegalStateException("either File object or text content must be set");
            }
            if (this.content != null && this.content.trim().isEmpty()) {
                throw new IllegalStateException("either File object or text content must be set");
            }
            if (this.file != null) {
                if (!this.file.exists() && this.file.isDirectory()) {
                    throw new IllegalStateException("file must be exists and not a directory");
                }
                if (!this.file.canRead()) {
                    throw new IllegalStateException("file must be readable");
                }
            }
        }
    }
}

