/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.alert;

public class SMTP {
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static final String MAIL_SMTP_USERNAME = "mail.smtp.username";
    public static final String MAIL_SMTP_PASSWORD = "mail.smtp.password";
    private String smtpHost;
    private int smtpPort;
    private boolean smtpAuth;
    private boolean smtpStartTlsEnable;
    private String smtpUsername;
    private String smtpPassword;

    private SMTP(Builder builder) {
        this.smtpHost = builder.smtpHost;
        this.smtpPort = builder.smtpPort;
        this.smtpAuth = builder.smtpAuth;
        this.smtpStartTlsEnable = builder.smtpStartTlsEnable;
        this.smtpUsername = builder.smtpUsername;
        this.smtpPassword = builder.smtpPassword;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public boolean isSmtpAuth() {
        return this.smtpAuth;
    }

    public boolean isSmtpStartTlsEnable() {
        return this.smtpStartTlsEnable;
    }

    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public static class Builder {
        private String smtpHost;
        private int smtpPort;
        private boolean smtpAuth;
        private boolean smtpStartTlsEnable;
        private String smtpUsername;
        private String smtpPassword;

        public Builder(String smtpHost, int smtpPort) {
            this.smtpHost = smtpHost;
            this.smtpPort = smtpPort;
        }

        public Builder smtpAuth(boolean smtpAuth) {
            this.smtpAuth = smtpAuth;
            return this;
        }

        public Builder smtpStartTlsEnable(boolean smtpStartTlsEnable) {
            this.smtpStartTlsEnable = smtpStartTlsEnable;
            return this;
        }

        public Builder smtpUsername(String smtpUsername) {
            this.smtpUsername = smtpUsername;
            return this;
        }

        public Builder smtpPassword(String smtpPassword) {
            this.smtpPassword = smtpPassword;
            return this;
        }

        public SMTP build() {
            this.validate();
            return new SMTP(this);
        }

        private void validate() throws IllegalStateException {
            if (this.smtpHost == null || this.smtpHost.isEmpty()) {
                throw new IllegalStateException("smtpHost is required");
            }
            if (this.smtpPort < 0 || this.smtpPort >= 65535) {
                throw new IllegalStateException("invalid smtpPort");
            }
            if (this.smtpAuth && (this.smtpUsername == null || this.smtpPassword == null)) {
                throw new IllegalStateException("smtpAuth is enabled but smtpUsername and smtpPassword is required");
            }
        }
    }
}

