/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.database;

import ch.weetech.database.RStoListMap;
import ch.weetech.database.StatementUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseStatementManager {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseStatementManager.class);

    public static List<Map<String, Object>> getHashMapList(String preparedStatement, Map<String, Object> hashmap, DataSource ds) {
        List<Map<String, Object>> result = null;
        long t0 = System.currentTimeMillis();
        try (Connection con = ds.getConnection();
             PreparedStatement stmt = con.prepareStatement(preparedStatement, 1005, 1007);){
            StatementUtil.setStatement(hashmap, stmt);
            try (ResultSet rs = stmt.executeQuery();){
                result = RStoListMap.getMapList(rs);
            }
            long ms = System.currentTimeMillis() - t0;
            if (logger.isDebugEnabled()) {
                logger.debug("Duration sql: [{}ms]", (Object)ms);
            } else if (ms > 1000L && ms <= 10000L) {
                logger.warn("Duration slow sql: [{}ms]", (Object)ms);
            } else if (ms > 10000L) {
                logger.error("Duration slow x2 sql: [{}ms]", (Object)ms);
            }
        }
        catch (Exception e) {
            logger.error("unable to execute sql query", (Throwable)e);
        }
        return result;
    }
}

