/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.database;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RStoListMap {
    private static final Logger logger = LoggerFactory.getLogger(RStoListMap.class);

    public static List<Map<String, Object>> getMapList(ResultSet resultSet) throws SQLException, NullPointerException {
        if (resultSet == null) {
            throw new NullPointerException("resultset is null");
        }
        ArrayList<Map<String, Object>> hashResults = null;
        String[] columnNames = null;
        resultSet.last();
        int numberOfRows = resultSet.getRow();
        hashResults = new ArrayList<Map<String, Object>>(numberOfRows);
        ResultSetMetaData resultSetMega = resultSet.getMetaData();
        int numberOfColumns = resultSetMega.getColumnCount();
        if (numberOfRows == 0 && numberOfColumns != 0) {
            if (resultSetMega.getColumnLabel(1).equals("GENERATED_KEY")) {
                hashResults = new ArrayList(1);
                hashResults.add(new LinkedHashMap());
                return hashResults;
            }
            return null;
        }
        columnNames = new String[numberOfColumns];
        for (int i = 1; i <= numberOfColumns; ++i) {
            columnNames[i - 1] = resultSetMega.getColumnLabel(i);
        }
        resultSet.first();
        if (numberOfRows != 0) {
            do {
                for (SQLWarning warning = resultSet.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    String message = warning.getMessage();
                    String sqlState = warning.getSQLState();
                    int errorCode = warning.getErrorCode();
                    logger.warn("message: {} \nsqlState: {} \nerrorCode: {}", new Object[]{message, sqlState, errorCode});
                }
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                for (int i = 0; i < numberOfColumns; ++i) {
                    Object myObject = null;
                    try {
                        myObject = resultSet.getObject(columnNames[i]);
                        linkedHashMap.put(columnNames[i], myObject);
                        continue;
                    }
                    catch (NullPointerException e) {
                        linkedHashMap.put(columnNames[i], null);
                    }
                }
                hashResults.add(linkedHashMap);
            } while (resultSet.next());
        }
        return hashResults;
    }

    public static List<Map<String, String>> toMapList(ResultSet results) throws SQLException {
        int numCols = results.getMetaData().getColumnCount();
        ResultSetMetaData rsmd = results.getMetaData();
        LinkedList<Map<String, String>> dbRes = new LinkedList<Map<String, String>>();
        while (results.next()) {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>(numCols);
            for (int i = 1; i <= numCols; ++i) {
                m.put(rsmd.getColumnName(i), results.getString(i));
            }
            dbRes.add(m);
        }
        return dbRes;
    }
}

