/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.network;

import ch.weetech.network.HttpResponse;
import ch.weetech.network.HttpResponseCode;
import ch.weetech.network.HttpUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class HttpClientApp {
    private HttpClient httpClient = null;

    public HttpClientApp(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClientApp(int connectTimeout) {
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(connectTimeout)).version(HttpClient.Version.HTTP_2).build();
    }

    public HttpResponse get(String url, String userAgent, int readTimeout, int retriesCount) {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(url)).timeout(Duration.ofSeconds(readTimeout)).setHeader("User-Agent", userAgent).build();
        HttpResponse httpResponse = new HttpResponse();
        int tries = retriesCount;
        do {
            StringWriter sw;
            try {
                java.net.http.HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                httpResponse.setStatusCode(response.statusCode());
                httpResponse.setContent(response.body());
                break;
            }
            catch (HttpConnectTimeoutException e) {
                httpResponse.setStatusCode(HttpResponseCode.CLIENT_CONNECT_TIMEOUT);
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                httpResponse.setError(sw.toString());
            }
            catch (HttpTimeoutException e) {
                httpResponse.setStatusCode(HttpResponseCode.CLIENT_READ_TIMEOUT);
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                httpResponse.setError(sw.toString());
            }
            catch (IOException e) {
                httpResponse.setStatusCode(HttpResponseCode.CLIENT_IO_ERROR);
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                httpResponse.setError(sw.toString());
            }
            catch (InterruptedException e) {
                httpResponse.setStatusCode(HttpResponseCode.CLIENT_INTERRUPTED_EXCEPTION);
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                httpResponse.setError(sw.toString());
            }
        } while (--tries > 0);
        return httpResponse;
    }

    public HttpResponse get(String url) {
        return this.get(url, "HttpClientApp", 5, 0);
    }

    public HttpResponse post(String url, Map<Object, Object> data, Map<String, String> headers, String userAgent, int readTimeout, int retriesCount) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        requestBuilder.uri(URI.create(url));
        requestBuilder.timeout(Duration.ofSeconds(readTimeout));
        requestBuilder.setHeader("User-Agent", userAgent);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            requestBuilder.header(entry.getKey(), entry.getValue());
        }
        if (data != null) {
            requestBuilder.POST(HttpUtil.buildFormDataFromMap(data));
        } else {
            requestBuilder.POST(HttpRequest.BodyPublishers.noBody());
        }
        HttpRequest request = requestBuilder.build();
        HttpResponse httpResponse = new HttpResponse();
        int tries = retriesCount;
        do {
            StringWriter sw;
            try {
                java.net.http.HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                httpResponse.setStatusCode(response.statusCode());
                httpResponse.setContent(response.body());
                break;
            }
            catch (HttpConnectTimeoutException e) {
                httpResponse.setStatusCode(HttpResponseCode.CLIENT_CONNECT_TIMEOUT);
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                httpResponse.setError(sw.toString());
            }
            catch (HttpTimeoutException e) {
                httpResponse.setStatusCode(HttpResponseCode.CLIENT_READ_TIMEOUT);
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                httpResponse.setError(sw.toString());
            }
            catch (IOException e) {
                httpResponse.setStatusCode(HttpResponseCode.CLIENT_IO_ERROR);
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                httpResponse.setError(sw.toString());
            }
            catch (InterruptedException e) {
                httpResponse.setStatusCode(HttpResponseCode.CLIENT_INTERRUPTED_EXCEPTION);
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                httpResponse.setError(sw.toString());
            }
        } while (--tries > 0);
        return httpResponse;
    }

    public HttpResponse post(String url, Map<Object, Object> data) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return this.post(url, data, headers, "HttpClientApp", 5, 0);
    }
}

