/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.validator;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Validator<T> {
    public final List<String> TOXIC_CHAR = List.of("AND", "1=1", "OR", "iKO", "nvOpzp", "'A=0", "<", ">", "crlfinjection", "SELECT ", "(", ")", "/", "WHEN ", " END", "WAITFOR ", "Set-Cookie:", "RLIKE", "CASE", "THEN", "UNION", "NULL", "CONCAT", "HAVING", "waitfor");

    public abstract boolean isValid(T var1);

    public boolean isValidString(String v) {
        if (v == null || v.isEmpty()) {
            return false;
        }
        for (int i = 0; i < v.length(); ++i) {
            if (Character.isDefined(v.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containToxicChar(String v, int minShouldMatch) {
        if (v == null || v.isEmpty()) {
            return false;
        }
        if (!v.contains(" ")) {
            return false;
        }
        List matches = Stream.of(v.split(" ")).filter(s -> this.TOXIC_CHAR.contains(s)).collect(Collectors.toList());
        return matches.size() >= minShouldMatch;
    }

    public boolean containToxicCharCheck1(String v, int minShouldMatch) {
        if (v == null || v.isEmpty()) {
            return false;
        }
        List matches = this.TOXIC_CHAR.stream().filter(t -> v.contains((CharSequence)t)).collect(Collectors.toList());
        return matches.size() >= minShouldMatch;
    }

    public boolean isDigit(String v) {
        for (int i = 0; i < v.length(); ++i) {
            if (Character.isDigit(v.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

