package cloud.proxi.sdkv3.utils

import java.text.Normalizer

object StringUtils {

    fun normalizeToAscii(string: String): String {
        val notAscii = "[^\\p{ASCII}]"
        return try {
            Normalizer.normalize(string, Normalizer.Form.NFD)
                .replace(notAscii.toRegex(), "")
        } catch (assertionError: AssertionError) {
            //very rarely Normalizer.Form.NFD is not recognized as valid and AssertionError is thrown
            //it should not be possible but it happens. Only on some devices with Android 6 (api 23)
            //if normalization is not possible just ignore non ascii characters
            string.replace(notAscii.toRegex(), "")
        }
    }
}