package cloud.proxi.sdkv3.api

import cloud.proxi.sdkv3.api.model.AnalyticsRequestApiModel
import cloud.proxi.sdkv3.api.services.CreateHeaders
import cloud.proxi.sdkv3.api.services.EnableCache
import cloud.proxi.sdkv3.database.IdStorage
import com.russhwolf.settings.Settings
import io.ktor.client.*
import io.ktor.client.call.*
import io.ktor.client.plugins.*
import io.ktor.client.plugins.cache.*
import io.ktor.client.plugins.cache.storage.*
import io.ktor.client.plugins.compression.*
import io.ktor.client.plugins.contentnegotiation.*
import io.ktor.client.plugins.logging.*
import io.ktor.client.request.*
import io.ktor.client.statement.*
import io.ktor.http.*
import io.ktor.serialization.kotlinx.json.*
import io.ktor.util.*
import io.ktor.util.collections.*
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.json.Json

class Api(
    val idStorage: IdStorage,
    private val createHeaders: CreateHeaders,
    settings: Settings
) {

    @OptIn(ExperimentalSerializationApi::class)
    private val httpClient = HttpClient {
        install(HttpTimeout)
        install(ContentEncoding) {
            gzip()
        }
        install(ContentNegotiation) {
            json(Json {
                ignoreUnknownKeys = true
                explicitNulls = false
                encodeDefaults = false
            })
        }
    }

    init {
        EnableCache(settings).invoke(httpClient)
    }

    suspend fun sendAnalytics(analyticsRequestApiModel: AnalyticsRequestApiModel): HttpResponse =
        httpClient.post("https://cdn.proxi.cloud/api/v2/sdk/gateways/${idStorage.getApiKey()}/analytics.json") {
            contentType(ContentType.Application.Json)
            headers { appendAll(createHeaders.invoke()) }
            setBody(analyticsRequestApiModel)
        }

    suspend fun retrieveLayout(attributes: Map<String, String>) =
        httpClient.get("https://cdn.proxi.cloud/api/v2/sdk/gateways/${idStorage.getApiKey()}/interactions.json") {
            contentType(ContentType.Application.Json)
            headers { appendAll(createHeaders.invoke()) }
            timeout {
                socketTimeoutMillis = 30 * 1000
            }
        }
}