package cloud.proxi.sdkv3.api.model

sealed interface ApiResult<T : Any> {
    class Success<T : Any>(val data: T) : ApiResult<T>
    class NotModified<T: Any>: ApiResult<T>
    class HttpError<T : Any>(val code: Int, val message: String? = null) : ApiResult<T>
    class IOError<T : Any>(val e: Throwable) : ApiResult<T>
}