package cloud.proxi.sdkv3.api.model

import cloud.proxi.sdkv3.utils.DoubleLowerPrecisionSerializer
import cloud.proxi.sdkv3.utils.DoubleMediumPrecisionSerializer
import kotlinx.serialization.Serializable

@Serializable
data class LocationDetailsApiModel(
    @Serializable(with = DoubleMediumPrecisionSerializer::class)
    val latitude: Double,
    @Serializable(with = DoubleMediumPrecisionSerializer::class)
    val longitude: Double,
    val timeDiff: Long,
    @Serializable(with = DoubleLowerPrecisionSerializer::class)
    val horizontalAccuracy: Double,
    @Serializable(with = DoubleLowerPrecisionSerializer::class)
    val altitude: Double?,
    @Serializable(with = DoubleLowerPrecisionSerializer::class)
    val verticalAccuracy: Double?,
    @Serializable(with = DoubleLowerPrecisionSerializer::class)
    val speed: Double?,
    @Serializable(with = DoubleLowerPrecisionSerializer::class)
    val speedAccuracy: Double?,
    @Serializable(with = DoubleLowerPrecisionSerializer::class)
    val bearing: Double?,
    @Serializable(with = DoubleLowerPrecisionSerializer::class)
    val bearingAccuracy: Double?
)