package cloud.proxi.sdkv3.api.services

import cloud.proxi.sdkv3.api.Api
import cloud.proxi.sdkv3.api.model.AnalyticsRequestApiModel
import cloud.proxi.sdkv3.api.model.ApiResult
import cloud.proxi.sdkv3.api.model.LayoutApiModel
import io.ktor.client.call.*
import io.ktor.http.*

class ApiService(private val api: Api) {

    suspend fun sendAnalytics(analyticsRequestApiModel: AnalyticsRequestApiModel) =
        try {
            if (!api.idStorage.isEnabled()) {
                throw RuntimeException("SDK not enabled")
            }
            val response = api.sendAnalytics(analyticsRequestApiModel)
            val status = response.status
            if (status.isSuccess()) {
                ApiResult.Success(response)
            } else {
                ApiResult.HttpError(status.value)
            }
        } catch (t: Throwable) {
            ApiResult.IOError(t)
        }

    suspend fun retrieveLayout(): ApiResult<LayoutApiModel> =
        try {
            if (!api.idStorage.isEnabled()) {
                throw RuntimeException("SDK not enabled")
            }
            val response = api.retrieveLayout(emptyMap())
            val status = response.status
            when {
                status.isSuccess() -> {
                    ApiResult.Success(response.body() as LayoutApiModel)
                }
                status == HttpStatusCode.NotModified -> {
                    ApiResult.NotModified()
                }
                else -> {
                    ApiResult.HttpError(status.value)
                }
            }
        } catch (t: Throwable) {
            ApiResult.IOError(t)
        }
}