package cloud.proxi.sdkv3.api.services

import cloud.proxi.sdkv3.PCShared
import cloud.proxi.sdkv3.api.UserAgent
import cloud.proxi.sdkv3.utils.UUIDUtils
import cloud.proxi.sdkv3.utils.locale
import io.ktor.http.*

class CreateHeaders(private val userAgent: UserAgent) {
    companion object {
        private const val HEADERS_AID_KEY = "X-aid"

        private const val HEADERS_DEVICE_ID_KEY = "X-iid"

        private const val HEADERS_USER_AGENT_KEY = "User-Agent"

        private const val HEADERS_DEVICE_LOCALE = "X-Device-Locale"
    }

    fun invoke() = HeadersBuilder().apply {
        append(HEADERS_AID_KEY, PCShared.idStorage.getAdvertisingIdentifier())
        append(HEADERS_DEVICE_ID_KEY, UUIDUtils.uuidWithoutDashesString(PCShared.idStorage.getAppId()))
        append(HEADERS_USER_AGENT_KEY, userAgent.get)
        append(HEADERS_DEVICE_LOCALE, locale())
    }
}