package cloud.proxi.sdkv3.api.services

import com.russhwolf.settings.Settings
import io.ktor.client.*
import io.ktor.client.plugins.*
import io.ktor.http.*

class EnableCache(val settings: Settings) {

    companion object {
        const val CACHE_KEY = "cloud_proxi_sdk_cache_etag"
    }

    fun invoke(httpClient: HttpClient) =
        httpClient.plugin(HttpSend).intercept { request ->
            val url = request.url.buildString()
            val eTag = readETag()
            if (!url.contains("interactions")) {
                execute(request)
            } else if (eTag.isNullOrEmpty()) {
                val original = execute(request)
                original.response.etag()?.let { storeETag(it) }
                original
            } else {
                request.headers.append("If-None-Match", eTag)
                execute(request)
            }
        }

    private fun storeETag(eTag: String) =
        settings.putString(CACHE_KEY, eTag)

    private fun readETag() =
        settings.getStringOrNull(CACHE_KEY)
}