package cloud.proxi.sdkv3.database

import kotlin.Long
import kotlin.String

public data class Action(
  public val id: Long,
  public val actionId: String,
  public val dt: Long,
  public val trigger: Long,
  public val pid: String,
  public val geohash: String?,
  public val actionInstanceUuid: String,
  public val lifecycle: Long,
  public val locationPermission: Long,
  public val locationDetailsId: Long?
) {
  public override fun toString(): String = """
  |Action [
  |  id: $id
  |  actionId: $actionId
  |  dt: $dt
  |  trigger: $trigger
  |  pid: $pid
  |  geohash: $geohash
  |  actionInstanceUuid: $actionInstanceUuid
  |  lifecycle: $lifecycle
  |  locationPermission: $locationPermission
  |  locationDetailsId: $locationDetailsId
  |]
  """.trimMargin()
}
