package cloud.proxi.sdkv3.database

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface ActionCappingQueries : Transacter {
  public fun <T : Any> findLastShownForActionId(actionUuid: String, mapper: (
    actionUuid: String,
    lastShown: Long,
    capping: Long
  ) -> T): Query<T>

  public fun findLastShownForActionId(actionUuid: String): Query<ActionCapping>

  public fun insertLastShown(
    actionUuid: String,
    lastShown: Long,
    capping: Long
  ): Unit

  public fun updateLastShown(lastShown: Long, actionUuid: String): Unit
}
