package cloud.proxi.sdkv3.database

import com.squareup.sqldelight.ColumnAdapter

object Adapters {
    val listOfStringsAdapter = object : ColumnAdapter<MutableList<String>, String> {
        override fun decode(databaseValue: String) =
            if (databaseValue.isEmpty()) {
                mutableListOf()
            } else {
                databaseValue.split(",").toMutableList()
            }
        override fun encode(value: MutableList<String>) = value.joinToString(separator = ",")
    }
}