package cloud.proxi.sdkv3.database

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface AnalyticsActionQueries : Transacter {
  public fun <T : Any> selectAll(mapper: (
    id: Long,
    actionId: String,
    dt: Long,
    trigger: Long,
    pid: String,
    geohash: String?,
    actionInstanceUuid: String,
    lifecycle: Long,
    locationPermission: Long,
    locationDetailsId: Long?
  ) -> T): Query<T>

  public fun selectAll(): Query<Action>

  public fun insert(
    actionId: String,
    dt: Long,
    trigger: Long,
    pid: String,
    geohash: String?,
    actionInstanceUuid: String,
    lifecycle: Long,
    locationPermission: Long,
    locationDetailsId: Long?
  ): Unit

  public fun delete(actionInstanceUuid: String): Unit
}
