@file:Suppress("UNSUPPORTED_FEATURE")

package cloud.proxi.sdkv3.database

import com.squareup.sqldelight.TransactionWithReturn

fun ProxiCloudDatabase.runGettingLastId(
    body: TransactionWithReturn<Long>.() -> Unit
): Long {
    return transactionWithResult {
        body.invoke(this)
        utilQueries.lastInsertedRowId().executeAsOne()
    }
}