package cloud.proxi.sdkv3.database

import com.squareup.sqldelight.db.SqlDriver

@Suppress("NO_ACTUAL_FOR_EXPECT")
expect class DriverFactory {
    fun createDriver(): SqlDriver
}

fun createDatabase(driverFactory: DriverFactory): ProxiCloudDatabase {
    val driver = driverFactory.createDriver()
    return ProxiCloudDatabase(
        driver
    )
}