package cloud.proxi.sdkv3.database

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface GeofenceQueries : Transacter {
  public fun count(): Query<Long>

  public fun selectWithGeohash(geohash: String): Query<String>

  public fun findActionsForTrigger(geofence: String): Query<String>

  public fun <T : Any> selectAll(mapper: (
    id: Long,
    geofence: String,
    actions: String
  ) -> T): Query<T>

  public fun selectAll(): Query<Geofence>

  public fun lastInsertedRowId(): Query<Long>

  public fun insert(geofence: String, actions: String): Unit

  public fun update(`value`: String, geofence: String): Unit
}
