package cloud.proxi.sdkv3.database

import com.benasher44.uuid.uuid4
import com.russhwolf.settings.Settings

class IdStorage(private val settings: Settings) {

    companion object {
        private const val AID_PREFERENCES_KEY =
            "cloud.proxi.preferences.network.advertisingIdentifier"

        private const val INSTALLATION_ID_PREFERENCES_KEY =
            "cloud.proxi.preferences.installationUuidIdentifier"

        private const val API_KEY_PREFERENCES_KEY = "cloud.proxi.preferences.apiKey"
    }

    init {
        if (getAppId().isEmpty())
            settings.putString(INSTALLATION_ID_PREFERENCES_KEY, uuid4().toString())
    }

    fun saveAdvertisingIdentifier(aid: String) {
        settings.putString(AID_PREFERENCES_KEY, aid)
    }

    fun getAdvertisingIdentifier(): String {
        return settings.getString(AID_PREFERENCES_KEY, "")
    }

    fun getAppId(): String {
        return settings.getString(INSTALLATION_ID_PREFERENCES_KEY, "")
    }

    fun setApiKey(apiKey: String) {
        settings.putString(API_KEY_PREFERENCES_KEY, apiKey)
    }

    fun getApiKey(): String {
        return settings.getString(
            API_KEY_PREFERENCES_KEY,
            ""
        )
    }

    fun setEnabled(enabled: Boolean) {
        settings.putBoolean("enabled", enabled)
    }

    fun isEnabled(): Boolean {
        return settings.getBoolean("enabled", true)
    }
}