package cloud.proxi.sdkv3.database

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface LayoutActionModelQueries : Transacter {
  public fun <T : Any> findTriggersForId(id: Long, mapper: (
    id: Long,
    eid: String,
    trigger: Int,
    type: Long,
    suppressionTime: Long?,
    delay: Long?,
    content: String,
    deliveryAt: String?
  ) -> T): Query<T>

  public fun findTriggersForId(id: Long): Query<LayoutAction>

  public fun lastInsertedRowId(): Query<Long>

  public fun insert(
    eid: String,
    trigger: Int,
    type: Long,
    suppressionTime: Long?,
    delay: Long?,
    content: String,
    deliveryAt: String?
  ): Unit
}
