package cloud.proxi.sdkv3.database

import kotlin.Double
import kotlin.Long
import kotlin.String

public data class LocationDetails(
  public val id: Long,
  public val latitude: Double,
  public val longitude: Double,
  public val accuracy: Double,
  public val timeDiff: Long,
  public val altitude: Double?,
  public val verticalAccuracy: Double?,
  public val speed: Double?,
  public val speedAccuracy: Double?,
  public val bearing: Double?,
  public val bearingAccuracy: Double?
) {
  public override fun toString(): String = """
  |LocationDetails [
  |  id: $id
  |  latitude: $latitude
  |  longitude: $longitude
  |  accuracy: $accuracy
  |  timeDiff: $timeDiff
  |  altitude: $altitude
  |  verticalAccuracy: $verticalAccuracy
  |  speed: $speed
  |  speedAccuracy: $speedAccuracy
  |  bearing: $bearing
  |  bearingAccuracy: $bearingAccuracy
  |]
  """.trimMargin()
}
