package cloud.proxi.sdkv3.database

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Double
import kotlin.Long
import kotlin.Unit

public interface LocationDetailsQueries : Transacter {
  public fun lastInsertedRowId(): Query<Long>

  public fun <T : Any> getDetailsForId(id: Long, mapper: (
    id: Long,
    latitude: Double,
    longitude: Double,
    accuracy: Double,
    timeDiff: Long,
    altitude: Double?,
    verticalAccuracy: Double?,
    speed: Double?,
    speedAccuracy: Double?,
    bearing: Double?,
    bearingAccuracy: Double?
  ) -> T): Query<T>

  public fun getDetailsForId(id: Long): Query<LocationDetails>

  public fun insert(
    latitude: Double,
    longitude: Double,
    accuracy: Double,
    timeDiff: Long,
    altitude: Double?,
    verticalAccuracy: Double?,
    speed: Double?,
    speedAccuracy: Double?,
    bearing: Double?,
    bearingAccuracy: Double?
  ): Unit
}
