package cloud.proxi.sdkv3.database

import cloud.proxi.sdkv3.database.shared.newInstance
import cloud.proxi.sdkv3.database.shared.schema
import com.squareup.sqldelight.Transacter
import com.squareup.sqldelight.db.SqlDriver

public interface ProxiCloudDatabase : Transacter {
  public val actionCappingQueries: ActionCappingQueries

  public val analyticsActionQueries: AnalyticsActionQueries

  public val geofenceQueries: GeofenceQueries

  public val layoutActionModelQueries: LayoutActionModelQueries

  public val locationDetailsQueries: LocationDetailsQueries

  public val triggerLogQueriesQueries: TriggerLogQueriesQueries

  public val utilQueries: UtilQueries

  public val wifiNetworksQueries: WifiNetworksQueries

  public companion object {
    public val Schema: SqlDriver.Schema
      get() = ProxiCloudDatabase::class.schema

    public operator fun invoke(driver: SqlDriver): ProxiCloudDatabase =
        ProxiCloudDatabase::class.newInstance(driver)
  }
}
