package cloud.proxi.sdkv3.database

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface TriggerLogQueriesQueries : Transacter {
  public fun <T : Any> selectAll(mapper: (
    id: Long,
    dt: Long,
    pid: String,
    geohash: String?,
    pairingId: String?,
    lifecycle: Long,
    locationPermission: Long,
    locationDetailsId: Long?
  ) -> T): Query<T>

  public fun selectAll(): Query<TriggerLog>

  public fun insert(
    dt: Long,
    pid: String,
    geohash: String?,
    pairingId: String?,
    lifecycle: Long,
    locationPermission: Long,
    locationDetailsId: Long?
  ): Unit

  public fun delete(): Unit
}
