package cloud.proxi.sdkv3.database

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface WifiNetworksQueries : Transacter {
  public fun checkLastInserted(mac: String): Query<Long>

  public fun <T : Any> selectAll(mapper: (
    id: Long,
    dt: Long,
    pid: String,
    geohash: String?,
    locationDetailsId: Long?,
    rssi: Int,
    frequency: Int,
    mac: String,
    lifecycle: Long,
    locationPermission: Long
  ) -> T): Query<T>

  public fun selectAll(): Query<WifiNetworks>

  public fun insert(
    dt: Long,
    pid: String,
    geohash: String?,
    locationDetailsId: Long?,
    rssi: Int,
    frequency: Int,
    mac: String,
    lifecycle: Long,
    locationPermission: Long
  ): Unit

  public fun delete(): Unit
}
