package cloud.proxi.sdkv3.database.shared

import cloud.proxi.sdkv3.database.Action
import cloud.proxi.sdkv3.database.ActionCapping
import cloud.proxi.sdkv3.database.ActionCappingQueries
import cloud.proxi.sdkv3.database.AnalyticsActionQueries
import cloud.proxi.sdkv3.database.Geofence
import cloud.proxi.sdkv3.database.GeofenceQueries
import cloud.proxi.sdkv3.database.LayoutAction
import cloud.proxi.sdkv3.database.LayoutActionModelQueries
import cloud.proxi.sdkv3.database.LocationDetails
import cloud.proxi.sdkv3.database.LocationDetailsQueries
import cloud.proxi.sdkv3.database.ProxiCloudDatabase
import cloud.proxi.sdkv3.database.TriggerLog
import cloud.proxi.sdkv3.database.TriggerLogQueriesQueries
import cloud.proxi.sdkv3.database.UtilQueries
import cloud.proxi.sdkv3.database.WifiNetworks
import cloud.proxi.sdkv3.database.WifiNetworksQueries
import com.squareup.sqldelight.Query
import com.squareup.sqldelight.TransacterImpl
import com.squareup.sqldelight.`internal`.copyOnWriteList
import com.squareup.sqldelight.db.SqlCursor
import com.squareup.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Double
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.MutableList
import kotlin.reflect.KClass

internal val KClass<ProxiCloudDatabase>.schema: SqlDriver.Schema
  get() = ProxiCloudDatabaseImpl.Schema

internal fun KClass<ProxiCloudDatabase>.newInstance(driver: SqlDriver): ProxiCloudDatabase =
    ProxiCloudDatabaseImpl(driver)

private class ProxiCloudDatabaseImpl(
  driver: SqlDriver
) : TransacterImpl(driver), ProxiCloudDatabase {
  public override val actionCappingQueries: ActionCappingQueriesImpl =
      ActionCappingQueriesImpl(this, driver)

  public override val analyticsActionQueries: AnalyticsActionQueriesImpl =
      AnalyticsActionQueriesImpl(this, driver)

  public override val geofenceQueries: GeofenceQueriesImpl = GeofenceQueriesImpl(this, driver)

  public override val layoutActionModelQueries: LayoutActionModelQueriesImpl =
      LayoutActionModelQueriesImpl(this, driver)

  public override val locationDetailsQueries: LocationDetailsQueriesImpl =
      LocationDetailsQueriesImpl(this, driver)

  public override val triggerLogQueriesQueries: TriggerLogQueriesQueriesImpl =
      TriggerLogQueriesQueriesImpl(this, driver)

  public override val utilQueries: UtilQueriesImpl = UtilQueriesImpl(this, driver)

  public override val wifiNetworksQueries: WifiNetworksQueriesImpl = WifiNetworksQueriesImpl(this,
      driver)

  public object Schema : SqlDriver.Schema {
    public override val version: Int
      get() = 1

    public override fun create(driver: SqlDriver): Unit {
      driver.execute(null, """
          |CREATE TABLE LayoutAction (
          |  id INTEGER PRIMARY KEY,
          |  eid TEXT NOT NULL UNIQUE,
          |  trigger INTEGER NOT NULL,
          |  type INTEGER NOT NULL,
          |  suppressionTime INTEGER,
          |  delay INTEGER DEFAULT 0,
          |  content TEXT NOT NULL,
          |  deliveryAt TEXT
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE LocationDetails(
          |id INTEGER PRIMARY KEY AUTOINCREMENT,
          |latitude REAL NOT NULL,
          |longitude REAL NOT NULL,
          |accuracy REAL NOT NULL,
          |timeDiff INTEGER NOT NULL,
          |altitude REAL DEFAULT NULL,
          |verticalAccuracy REAL DEFAULT NULL,
          |speed REAL DEFAULT NULL,
          |speedAccuracy REAL DEFAULT NULL,
          |bearing REAL DEFAULT NULL,
          |bearingAccuracy REAL DEFAULT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE TriggerLog (
          |  id INTEGER PRIMARY KEY AUTOINCREMENT,
          |  dt INTEGER NOT NULL,
          |  pid TEXT NOT NULL,
          |  geohash TEXT,
          |  pairingId Text,
          |  lifecycle INTEGER NOT NULL,
          |  locationPermission INTEGER NOT NULL,
          |  locationDetailsId INTEGER
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE ActionCapping (
          |  actionUuid TEXT NOT NULL PRIMARY KEY,
          |  lastShown INTEGER NOT NULL,
          |  capping INTEGER NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE WifiNetworks (
          |  id INTEGER PRIMARY KEY AUTOINCREMENT,
          |  dt INTEGER NOT NULL,
          |  pid TEXT NOT NULL,
          |  geohash TEXT,
          |  locationDetailsId INTEGER,
          |  rssi INTEGER NOT NULL ,
          |  frequency INTEGER NOT NULL,
          |  mac TEXT NOT NULL,
          |  lifecycle INTEGER NOT NULL,
          |  locationPermission INTEGER NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE Action (
          |  id INTEGER PRIMARY KEY AUTOINCREMENT,
          |  actionId TEXT NOT NULL,
          |  dt INTEGER NOT NULL,
          |  trigger INTEGER NOT NULL,
          |  pid TEXT NOT NULL,
          |  geohash TEXT,
          |  actionInstanceUuid TEXT NOT NULL,
          |  lifecycle INTEGER NOT NULL,
          |  locationPermission INTEGER NOT NULL,
          |  locationDetailsId INTEGER
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE Geofence (
          |  id INTEGER PRIMARY KEY AUTOINCREMENT,
          |  geofence TEXT NOT NULL UNIQUE,
          |  actions TEXT NOT NULL)
          """.trimMargin(), 0)
    }

    public override fun migrate(
      driver: SqlDriver,
      oldVersion: Int,
      newVersion: Int
    ): Unit {
    }
  }
}

private class LayoutActionModelQueriesImpl(
  private val database: ProxiCloudDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), LayoutActionModelQueries {
  internal val findTriggersForId: MutableList<Query<*>> = copyOnWriteList()

  internal val lastInsertedRowId: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> findTriggersForId(id: Long, mapper: (
    id: Long,
    eid: String,
    trigger: Int,
    type: Long,
    suppressionTime: Long?,
    delay: Long?,
    content: String,
    deliveryAt: String?
  ) -> T): Query<T> = FindTriggersForIdQuery(id) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getLong(2)!!.toInt(),
      cursor.getLong(3)!!,
      cursor.getLong(4),
      cursor.getLong(5),
      cursor.getString(6)!!,
      cursor.getString(7)
    )
  }

  public override fun findTriggersForId(id: Long): Query<LayoutAction> = findTriggersForId(id) {
      id_, eid, trigger, type, suppressionTime, delay, content, deliveryAt ->
    LayoutAction(
      id_,
      eid,
      trigger,
      type,
      suppressionTime,
      delay,
      content,
      deliveryAt
    )
  }

  public override fun lastInsertedRowId(): Query<Long> = Query(1897038991, lastInsertedRowId,
      driver, "LayoutActionModel.sq", "lastInsertedRowId", "SELECT last_insert_rowid()") { cursor ->
    cursor.getLong(0)!!
  }

  public override fun insert(
    eid: String,
    trigger: Int,
    type: Long,
    suppressionTime: Long?,
    delay: Long?,
    content: String,
    deliveryAt: String?
  ): Unit {
    driver.execute(1968838289, """
    |INSERT OR IGNORE INTO LayoutAction (eid, trigger, type, suppressionTime, delay, content, deliveryAt)
    |VALUES (?,?,?,?,?,?, ?)
    """.trimMargin(), 7) {
      bindString(1, eid)
      bindLong(2, trigger.toLong())
      bindLong(3, type)
      bindLong(4, suppressionTime)
      bindLong(5, delay)
      bindString(6, content)
      bindString(7, deliveryAt)
    }
    notifyQueries(1968838289, {database.layoutActionModelQueries.findTriggersForId})
  }

  private inner class FindTriggersForIdQuery<out T : Any>(
    public val id: Long,
    mapper: (SqlCursor) -> T
  ) : Query<T>(findTriggersForId, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-2079689032,
        """SELECT * FROM LayoutAction WHERE id = ?""", 1) {
      bindLong(1, id)
    }

    public override fun toString(): String = "LayoutActionModel.sq:findTriggersForId"
  }
}

private class LocationDetailsQueriesImpl(
  private val database: ProxiCloudDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), LocationDetailsQueries {
  internal val lastInsertedRowId: MutableList<Query<*>> = copyOnWriteList()

  internal val getDetailsForId: MutableList<Query<*>> = copyOnWriteList()

  public override fun lastInsertedRowId(): Query<Long> = Query(-1040923893, lastInsertedRowId,
      driver, "LocationDetails.sq", "lastInsertedRowId", "SELECT last_insert_rowid()") { cursor ->
    cursor.getLong(0)!!
  }

  public override fun <T : Any> getDetailsForId(id: Long, mapper: (
    id: Long,
    latitude: Double,
    longitude: Double,
    accuracy: Double,
    timeDiff: Long,
    altitude: Double?,
    verticalAccuracy: Double?,
    speed: Double?,
    speedAccuracy: Double?,
    bearing: Double?,
    bearingAccuracy: Double?
  ) -> T): Query<T> = GetDetailsForIdQuery(id) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getDouble(1)!!,
      cursor.getDouble(2)!!,
      cursor.getDouble(3)!!,
      cursor.getLong(4)!!,
      cursor.getDouble(5),
      cursor.getDouble(6),
      cursor.getDouble(7),
      cursor.getDouble(8),
      cursor.getDouble(9),
      cursor.getDouble(10)
    )
  }

  public override fun getDetailsForId(id: Long): Query<LocationDetails> = getDetailsForId(id) { id_,
      latitude, longitude, accuracy, timeDiff, altitude, verticalAccuracy, speed, speedAccuracy,
      bearing, bearingAccuracy ->
    LocationDetails(
      id_,
      latitude,
      longitude,
      accuracy,
      timeDiff,
      altitude,
      verticalAccuracy,
      speed,
      speedAccuracy,
      bearing,
      bearingAccuracy
    )
  }

  public override fun insert(
    latitude: Double,
    longitude: Double,
    accuracy: Double,
    timeDiff: Long,
    altitude: Double?,
    verticalAccuracy: Double?,
    speed: Double?,
    speedAccuracy: Double?,
    bearing: Double?,
    bearingAccuracy: Double?
  ): Unit {
    driver.execute(1609436565, """
    |INSERT INTO LocationDetails(latitude,longitude,accuracy,timeDiff,altitude,verticalAccuracy,speed,speedAccuracy,bearing,bearingAccuracy)
    |VALUES (?,?,?,?,?,?,?,?,?,?)
    """.trimMargin(), 10) {
      bindDouble(1, latitude)
      bindDouble(2, longitude)
      bindDouble(3, accuracy)
      bindLong(4, timeDiff)
      bindDouble(5, altitude)
      bindDouble(6, verticalAccuracy)
      bindDouble(7, speed)
      bindDouble(8, speedAccuracy)
      bindDouble(9, bearing)
      bindDouble(10, bearingAccuracy)
    }
    notifyQueries(1609436565, {database.locationDetailsQueries.getDetailsForId})
  }

  private inner class GetDetailsForIdQuery<out T : Any>(
    public val id: Long,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getDetailsForId, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(880967100,
        """SELECT * FROM LocationDetails WHERE id = ? LIMIT 1""", 1) {
      bindLong(1, id)
    }

    public override fun toString(): String = "LocationDetails.sq:getDetailsForId"
  }
}

private class TriggerLogQueriesQueriesImpl(
  private val database: ProxiCloudDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), TriggerLogQueriesQueries {
  internal val selectAll: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> selectAll(mapper: (
    id: Long,
    dt: Long,
    pid: String,
    geohash: String?,
    pairingId: String?,
    lifecycle: Long,
    locationPermission: Long,
    locationDetailsId: Long?
  ) -> T): Query<T> = Query(1778290044, selectAll, driver, "TriggerLogQueries.sq", "selectAll", """
  |SELECT *
  |FROM TriggerLog
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3),
      cursor.getString(4),
      cursor.getLong(5)!!,
      cursor.getLong(6)!!,
      cursor.getLong(7)
    )
  }

  public override fun selectAll(): Query<TriggerLog> = selectAll { id, dt, pid, geohash, pairingId,
      lifecycle, locationPermission, locationDetailsId ->
    TriggerLog(
      id,
      dt,
      pid,
      geohash,
      pairingId,
      lifecycle,
      locationPermission,
      locationDetailsId
    )
  }

  public override fun insert(
    dt: Long,
    pid: String,
    geohash: String?,
    pairingId: String?,
    lifecycle: Long,
    locationPermission: Long,
    locationDetailsId: Long?
  ): Unit {
    driver.execute(-603391070, """
    |INSERT INTO TriggerLog(dt, pid, geohash, pairingId, lifecycle, locationPermission, locationDetailsId)
    |VALUES(?,?,?,?, ?,?,?)
    """.trimMargin(), 7) {
      bindLong(1, dt)
      bindString(2, pid)
      bindString(3, geohash)
      bindString(4, pairingId)
      bindLong(5, lifecycle)
      bindLong(6, locationPermission)
      bindLong(7, locationDetailsId)
    }
    notifyQueries(-603391070, {database.triggerLogQueriesQueries.selectAll})
  }

  public override fun delete(): Unit {
    driver.execute(-755057004, """DELETE FROM TriggerLog""", 0)
    notifyQueries(-755057004, {database.triggerLogQueriesQueries.selectAll})
  }
}

private class UtilQueriesImpl(
  private val database: ProxiCloudDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), UtilQueries {
  internal val lastInsertedRowId: MutableList<Query<*>> = copyOnWriteList()

  public override fun lastInsertedRowId(): Query<Long> = Query(1935767000, lastInsertedRowId,
      driver, "Util.sq", "lastInsertedRowId", "SELECT last_insert_rowid()") { cursor ->
    cursor.getLong(0)!!
  }
}

private class ActionCappingQueriesImpl(
  private val database: ProxiCloudDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), ActionCappingQueries {
  internal val findLastShownForActionId: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> findLastShownForActionId(actionUuid: String, mapper: (
    actionUuid: String,
    lastShown: Long,
    capping: Long
  ) -> T): Query<T> = FindLastShownForActionIdQuery(actionUuid) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getLong(1)!!,
      cursor.getLong(2)!!
    )
  }

  public override fun findLastShownForActionId(actionUuid: String): Query<ActionCapping> =
      findLastShownForActionId(actionUuid) { actionUuid_, lastShown, capping ->
    ActionCapping(
      actionUuid_,
      lastShown,
      capping
    )
  }

  public override fun insertLastShown(
    actionUuid: String,
    lastShown: Long,
    capping: Long
  ): Unit {
    driver.execute(-1846520891, """
    |INSERT INTO ActionCapping (actionUuid, lastShown, capping)
    |VALUES (?,?,?)
    """.trimMargin(), 3) {
      bindString(1, actionUuid)
      bindLong(2, lastShown)
      bindLong(3, capping)
    }
    notifyQueries(-1846520891, {database.actionCappingQueries.findLastShownForActionId})
  }

  public override fun updateLastShown(lastShown: Long, actionUuid: String): Unit {
    driver.execute(1291628469, """UPDATE ActionCapping SET lastShown = ? WHERE actionUuid = ?""", 2)
        {
      bindLong(1, lastShown)
      bindString(2, actionUuid)
    }
    notifyQueries(1291628469, {database.actionCappingQueries.findLastShownForActionId})
  }

  private inner class FindLastShownForActionIdQuery<out T : Any>(
    public val actionUuid: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(findLastShownForActionId, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-149840107,
        """SELECT * FROM ActionCapping WHERE actionUuid = ?""", 1) {
      bindString(1, actionUuid)
    }

    public override fun toString(): String = "ActionCapping.sq:findLastShownForActionId"
  }
}

private class WifiNetworksQueriesImpl(
  private val database: ProxiCloudDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), WifiNetworksQueries {
  internal val checkLastInserted: MutableList<Query<*>> = copyOnWriteList()

  internal val selectAll: MutableList<Query<*>> = copyOnWriteList()

  public override fun checkLastInserted(mac: String): Query<Long> = CheckLastInsertedQuery(mac) {
      cursor ->
    cursor.getLong(0)!!
  }

  public override fun <T : Any> selectAll(mapper: (
    id: Long,
    dt: Long,
    pid: String,
    geohash: String?,
    locationDetailsId: Long?,
    rssi: Int,
    frequency: Int,
    mac: String,
    lifecycle: Long,
    locationPermission: Long
  ) -> T): Query<T> = Query(1494327870, selectAll, driver, "WifiNetworks.sq", "selectAll", """
  |SELECT *
  |FROM WifiNetworks
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getLong(1)!!,
      cursor.getString(2)!!,
      cursor.getString(3),
      cursor.getLong(4),
      cursor.getLong(5)!!.toInt(),
      cursor.getLong(6)!!.toInt(),
      cursor.getString(7)!!,
      cursor.getLong(8)!!,
      cursor.getLong(9)!!
    )
  }

  public override fun selectAll(): Query<WifiNetworks> = selectAll { id, dt, pid, geohash,
      locationDetailsId, rssi, frequency, mac, lifecycle, locationPermission ->
    WifiNetworks(
      id,
      dt,
      pid,
      geohash,
      locationDetailsId,
      rssi,
      frequency,
      mac,
      lifecycle,
      locationPermission
    )
  }

  public override fun insert(
    dt: Long,
    pid: String,
    geohash: String?,
    locationDetailsId: Long?,
    rssi: Int,
    frequency: Int,
    mac: String,
    lifecycle: Long,
    locationPermission: Long
  ): Unit {
    driver.execute(-902697440, """
    |INSERT INTO WifiNetworks(dt, pid, geohash, locationDetailsId, rssi, frequency, mac, lifecycle, locationPermission)
    |VALUES(?,?,?,?,?, ?, ?,?,?)
    """.trimMargin(), 9) {
      bindLong(1, dt)
      bindString(2, pid)
      bindString(3, geohash)
      bindLong(4, locationDetailsId)
      bindLong(5, rssi.toLong())
      bindLong(6, frequency.toLong())
      bindString(7, mac)
      bindLong(8, lifecycle)
      bindLong(9, locationPermission)
    }
    notifyQueries(-902697440, {database.wifiNetworksQueries.checkLastInserted +
        database.wifiNetworksQueries.selectAll})
  }

  public override fun delete(): Unit {
    driver.execute(-1054363374, """DELETE FROM WifiNetworks""", 0)
    notifyQueries(-1054363374, {database.wifiNetworksQueries.checkLastInserted +
        database.wifiNetworksQueries.selectAll})
  }

  private inner class CheckLastInsertedQuery<out T : Any>(
    public val mac: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(checkLastInserted, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1586073297,
        """SELECT dt FROM WifiNetworks WHERE mac = ? ORDER BY dt DESC LIMIT 1""", 1) {
      bindString(1, mac)
    }

    public override fun toString(): String = "WifiNetworks.sq:checkLastInserted"
  }
}

private class AnalyticsActionQueriesImpl(
  private val database: ProxiCloudDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), AnalyticsActionQueries {
  internal val selectAll: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> selectAll(mapper: (
    id: Long,
    actionId: String,
    dt: Long,
    trigger: Long,
    pid: String,
    geohash: String?,
    actionInstanceUuid: String,
    lifecycle: Long,
    locationPermission: Long,
    locationDetailsId: Long?
  ) -> T): Query<T> = Query(-661361030, selectAll, driver, "AnalyticsAction.sq", "selectAll", """
  |SELECT *
  |FROM Action
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getLong(2)!!,
      cursor.getLong(3)!!,
      cursor.getString(4)!!,
      cursor.getString(5),
      cursor.getString(6)!!,
      cursor.getLong(7)!!,
      cursor.getLong(8)!!,
      cursor.getLong(9)
    )
  }

  public override fun selectAll(): Query<Action> = selectAll { id, actionId, dt, trigger, pid,
      geohash, actionInstanceUuid, lifecycle, locationPermission, locationDetailsId ->
    Action(
      id,
      actionId,
      dt,
      trigger,
      pid,
      geohash,
      actionInstanceUuid,
      lifecycle,
      locationPermission,
      locationDetailsId
    )
  }

  public override fun insert(
    actionId: String,
    dt: Long,
    trigger: Long,
    pid: String,
    geohash: String?,
    actionInstanceUuid: String,
    lifecycle: Long,
    locationPermission: Long,
    locationDetailsId: Long?
  ): Unit {
    driver.execute(-384767132, """
    |INSERT INTO Action(actionId, dt, trigger,pid,geohash,actionInstanceUuid, lifecycle, locationPermission, locationDetailsId)
    |VALUES(?,?,?,?,?,?,?,?,?)
    """.trimMargin(), 9) {
      bindString(1, actionId)
      bindLong(2, dt)
      bindLong(3, trigger)
      bindString(4, pid)
      bindString(5, geohash)
      bindString(6, actionInstanceUuid)
      bindLong(7, lifecycle)
      bindLong(8, locationPermission)
      bindLong(9, locationDetailsId)
    }
    notifyQueries(-384767132, {database.analyticsActionQueries.selectAll})
  }

  public override fun delete(actionInstanceUuid: String): Unit {
    driver.execute(-536433066, """
    |DELETE FROM Action
    |WHERE actionInstanceUuid = ?
    """.trimMargin(), 1) {
      bindString(1, actionInstanceUuid)
    }
    notifyQueries(-536433066, {database.analyticsActionQueries.selectAll})
  }
}

private class GeofenceQueriesImpl(
  private val database: ProxiCloudDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), GeofenceQueries {
  internal val count: MutableList<Query<*>> = copyOnWriteList()

  internal val selectWithGeohash: MutableList<Query<*>> = copyOnWriteList()

  internal val findActionsForTrigger: MutableList<Query<*>> = copyOnWriteList()

  internal val selectAll: MutableList<Query<*>> = copyOnWriteList()

  internal val lastInsertedRowId: MutableList<Query<*>> = copyOnWriteList()

  public override fun count(): Query<Long> = Query(681243330, count, driver, "Geofence.sq", "count",
      "SELECT count(*) FROM Geofence") { cursor ->
    cursor.getLong(0)!!
  }

  public override fun selectWithGeohash(geohash: String): Query<String> =
      SelectWithGeohashQuery(geohash) { cursor ->
    cursor.getString(0)!!
  }

  public override fun findActionsForTrigger(geofence: String): Query<String> =
      FindActionsForTriggerQuery(geofence) { cursor ->
    cursor.getString(0)!!
  }

  public override fun <T : Any> selectAll(mapper: (
    id: Long,
    geofence: String,
    actions: String
  ) -> T): Query<T> = Query(-238195912, selectAll, driver, "Geofence.sq", "selectAll",
      "SELECT * FROM Geofence") { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2)!!
    )
  }

  public override fun selectAll(): Query<Geofence> = selectAll { id, geofence, actions ->
    Geofence(
      id,
      geofence,
      actions
    )
  }

  public override fun lastInsertedRowId(): Query<Long> = Query(-314450790, lastInsertedRowId,
      driver, "Geofence.sq", "lastInsertedRowId", "SELECT last_insert_rowid()") { cursor ->
    cursor.getLong(0)!!
  }

  public override fun insert(geofence: String, actions: String): Unit {
    driver.execute(-185510042, """
    |INSERT OR IGNORE INTO Geofence(geofence, actions)
    |VALUES(?, ?)
    """.trimMargin(), 2) {
      bindString(1, geofence)
      bindString(2, actions)
    }
    notifyQueries(-185510042, {database.geofenceQueries.selectAll +
        database.geofenceQueries.selectWithGeohash + database.geofenceQueries.count +
        database.geofenceQueries.findActionsForTrigger})
  }

  public override fun update(`value`: String, geofence: String): Unit {
    driver.execute(159436150, """
    |UPDATE Geofence SET actions = actions || ',' || ?
    |WHERE geofence = ?
    """.trimMargin(), 2) {
      bindString(1, value)
      bindString(2, geofence)
    }
    notifyQueries(159436150, {database.geofenceQueries.selectAll +
        database.geofenceQueries.selectWithGeohash + database.geofenceQueries.count +
        database.geofenceQueries.findActionsForTrigger})
  }

  private inner class SelectWithGeohashQuery<out T : Any>(
    public val geohash: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(selectWithGeohash, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(18106064,
        """SELECT geofence FROM Geofence WHERE geofence LIKE ?""", 1) {
      bindString(1, geohash)
    }

    public override fun toString(): String = "Geofence.sq:selectWithGeohash"
  }

  private inner class FindActionsForTriggerQuery<out T : Any>(
    public val geofence: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(findActionsForTrigger, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(1891571846,
        """SELECT actions FROM Geofence WHERE geofence = ?""", 1) {
      bindString(1, geofence)
    }

    public override fun toString(): String = "Geofence.sq:findActionsForTrigger"
  }
}
