package cloud.proxi.sdkv3.geofence

import cloud.proxi.sdkv3.api.Api
import cloud.proxi.sdkv3.api.model.LayoutApiModel
import cloud.proxi.sdkv3.api.services.ApiService
import cloud.proxi.sdkv3.database.ProxiCloudDatabase
import cloud.proxi.sdkv3.geofence.model.PCGeofence
import cloud.proxi.sdkv3.model.Action
import cloud.proxi.sdkv3.repository.DataRepository
import cloud.proxi.sdkv3.utils.LocationUtils
import cloud.proxi.sdkv3.utils.geohash.GeoHash

class GeofenceRepository(private val proxiCloudDatabase: ProxiCloudDatabase, private val api: Api) {

    var layout: LayoutApiModel? = null

    val dataRepository = DataRepository(api, proxiCloudDatabase)
    val service = ApiService(api)
    val test = Repository(service, proxiCloudDatabase)

    suspend fun getNearestGeofences(
        latitude: Double,
        longitude: Double,
        count: Int = 20
    ): List<PCGeofence> {
        test.saveLayout()
        val geofences =
            dataRepository.getGeofences(GeoHash.withCharacterPrecision(latitude, longitude, 5))
                .mapNotNull {
                    try {
                        PCGeofence(it)
                    } catch (e: Exception) {
                        println(e)
                        null
                    }
                }.toMutableList()
        geofences.sortWith { a, b ->
            LocationUtils.calculateDistance(
                latitude,
                longitude,
                a.latitude,
                a.longitude
            ).compareTo(
                LocationUtils.calculateDistance(
                    latitude,
                    longitude,
                    b.latitude,
                    b.longitude
                )
            )
        }
        return geofences.take(count)
    }

    suspend fun actionsForTrigger(triggerId: String): List<Action> {
        return test.getActionsForTrigger(triggerId)
    }
}