package cloud.proxi.sdkv3.model

import com.benasher44.uuid.uuid4
import kotlinx.datetime.LocalDateTime

data class Action(
    /**
     * [ActionType] Represents type of an action:
     * DEEPLINK - clicking a notification should open a deeplinked app screen
     * WEBSITE - clicking a notification should open a website in a browser
     * IN_APP - clicking a notification should start an app with default settings
     * DATA - should not be presented to a user
     */
    val actionType: ActionType,
    val delayTime: Int?,
    val deliverAt: LocalDateTime?,
    val uuid: String,
    /**
     * User's transition that triggered an action
     * ENTER or EXIT
     */
    val transition: TransitionType,
    val expiryDate: String?,
    /**
     * Data of a notification to be shown to a user:
     * subject
     */
    val content: Content,
    /**
     * Unique identifier of an action instance (like single notification)
     */
    val instanceUuid: String = uuid4().toString(),
)