package cloud.proxi.sdkv3.model

import cloud.proxi.sdkv3.api.model.CampaignDataApiModel
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.jsonPrimitive

data class Content(
    val subject: String?,
    val body: String?,
    /**
     * deeplink or website url, activated by clicking a notification
     **/
    val uri: String?,
    /**
     * additional custom data
     */
    val payload: JsonObject?,
) {
    companion object {
        fun fromCampaignData(campaignDataApiModel: CampaignDataApiModel): Content {
            return Content(
                campaignDataApiModel.subject,
                campaignDataApiModel.body,
                campaignDataApiModel.url,
                campaignDataApiModel.payload
            )
        }
    }

    /**
     * Uri of an image to be shown in a notification
     */
    val imageUri: String?
        get() {
            return payload?.get("image")?.jsonPrimitive?.content
        }
}