package cloud.proxi.sdkv3.repository

import cloud.proxi.sdkv3.api.Api
import cloud.proxi.sdkv3.api.model.LayoutApiModel
import cloud.proxi.sdkv3.database.Geofence
import cloud.proxi.sdkv3.database.ProxiCloudDatabase
import cloud.proxi.sdkv3.utils.geohash.GeoHash
import cloud.proxi.sdkv3.utils.resultOf
import io.ktor.client.call.*

class DataRepository(val api: Api, val database: ProxiCloudDatabase) {

    fun getGeofences(geoHash: GeoHash): List<String> {
        return database.geofenceQueries.selectWithGeohash(geoHash.toBase32() + "%").executeAsList()
    }

}